/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DelegatingAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$delegation$security$authentication$DelegatingAuthenticator == null ? (class$com$atlassian$user$impl$delegation$security$authentication$DelegatingAuthenticator = DelegatingAuthenticator.class$("com.atlassian.user.impl.delegation.security.authentication.DelegatingAuthenticator")) : class$com$atlassian$user$impl$delegation$security$authentication$DelegatingAuthenticator));
    private List authenticators;
    private UserManager userManager;
    static /* synthetic */ Class class$com$atlassian$user$impl$delegation$security$authentication$DelegatingAuthenticator;

    public DelegatingAuthenticator() {
    }

    public DelegatingAuthenticator(UserManager userManager, List authenticators) {
        this.userManager = userManager;
        this.authenticators = authenticators;
    }

    public boolean authenticate(String username, String password) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
        }
        boolean authenticated = false;
        User unauthenticatedUser = this.userManager.getUser(username);
        Repository usersRepository = this.userManager.getRepository(unauthenticatedUser);
        for (int i = 0; i < this.authenticators.size(); ++i) {
            Authenticator authenticator = (Authenticator)this.authenticators.get(i);
            if (authenticator.getRepository() != usersRepository) continue;
            try {
                authenticated = authenticator.authenticate(username, password);
                if (!authenticated) continue;
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
                }
                return authenticated;
            }
            catch (EntityException e) {
                log.error((Object)(authenticator.getRepository() + ": " + e.getMessage()));
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_authenticate(" + username + ")"));
        }
        return authenticated;
    }

    public Repository getRepository() {
        return new DelegatingRepository(this.authenticators);
    }

    public void init(HashMap args) {
        this.userManager = (UserManager)args.get("userManager");
        this.authenticators = (List)args.get("authenticators");
    }

    public List getAuthenticators() {
        return this.authenticators;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

