/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.impl.hibernate.HibernateGroupManager;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;

public class HibernateExternalEntityGroupManager
extends HibernateGroupManager {
    public HibernateExternalEntityGroupManager() {
    }

    public HibernateExternalEntityGroupManager(HibernateRepository repository, ExternalEntityDAO externalEntityDao) {
        this.repository = repository;
        this.externalEntityDao = externalEntityDao;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (HibernateRepository)args.get("repository");
        this.externalEntityDao = (ExternalEntityDAO)args.get("externalEntityDAO");
        this.setSessionFactory(this.repository.getSessionFactory());
        InitializationCheck.validateArgs(args, new String[]{"repository", "externalEntityDAO"}, this);
    }

    public Pager getGroups(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        List groups = null;
        groups = this.getGroupsForExternalEntity(this.getCorrespondingExternalEntity(user));
        return new DefaultPager(groups);
    }

    public Pager getMemberNames(Group group) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (this.getGroup(group.getName()) == null) {
            return null;
        }
        Pager members = this.getExternalMemberNames(group);
        return members;
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return PagerUtils.EMPTY_PAGER;
    }

    public void addMembership(Group group, User user) throws EntityException {
        DefaultHibernateExternalEntity dEntity;
        HashSet<DefaultHibernateGroup> extEntityGroups;
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        if (!(group instanceof DefaultHibernateGroup)) {
            throw new IllegalArgumentException("Group is not a Hibernate entity [" + group.getClass().getName());
        }
        DefaultHibernateGroup dGroup = (DefaultHibernateGroup)group;
        HashSet<ExternalEntity> membership = null;
        ExternalEntity member = null;
        membership = dGroup.getExternalMembers();
        if (membership == null) {
            membership = new HashSet<ExternalEntity>();
            dGroup.setExternalMembers(membership);
        }
        if ((extEntityGroups = (dEntity = (DefaultHibernateExternalEntity)(member = this.getCorrespondingExternalEntity(user))).getGroups()) == null) {
            extEntityGroups = new HashSet<DefaultHibernateGroup>();
            dEntity.setGroups(extEntityGroups);
        }
        extEntityGroups.add(dGroup);
        membership.add(member);
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)dGroup);
            this.getHibernateTemplate().saveOrUpdate((Object)member);
            this.getSession().flush();
        }
        catch (HibernateException e) {
            throw new EntityException(e);
        }
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        return this.hasExternalMembership(defGroup, user);
    }

    public void removeMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        Set membership = null;
        Entity member = user;
        membership = defGroup.getExternalMembers();
        member = this.getCorrespondingExternalEntity(user);
        if (membership != null) {
            membership.remove(member);
            this.getHibernateTemplate().saveOrUpdate((Object)defGroup);
            this.getHibernateTemplate().flush();
        }
    }
}

