/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernateGroupManager
extends HibernateDaoSupport
implements GroupManager {
    public static final String GROUPNAME_FIELD = "groupname";
    public static final String GROUPID_FIELD = "groupid";
    public static final String ENTITYID_FIELD = "entityid";
    public static final String EXTERNAL_ENTITY_NAME_FIELD = "externalEntityName";
    protected HibernateRepository repository;
    protected UserManager userManager;
    protected ExternalEntityDAO externalEntityDao;

    public HibernateGroupManager() {
    }

    public HibernateGroupManager(HibernateRepository repository, UserManager userManager, ExternalEntityDAO externalEntityDao) {
        this.repository = repository;
        this.userManager = userManager;
        this.setSessionFactory(repository.getSessionFactory());
        this.externalEntityDao = externalEntityDao;
    }

    public Pager getGroups() throws EntityException {
        List result = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_findAll");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        if (result == null) {
            return new DefaultPager();
        }
        return new DefaultPager(result);
    }

    public Pager getGroups(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        Collection groups = null;
        groups = this.isUserExternal(user) ? ((DefaultHibernateExternalEntity)this.getCorrespondingExternalEntity(user)).getGroups() : this.getGroupsForLocalUser(user);
        return new DefaultPager(groups);
    }

    protected boolean isUserExternal(User user) {
        return !(user instanceof DefaultHibernateUser);
    }

    protected List getGroupsForLocalUser(User user) throws RepositoryException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        if (this.isUserExternal(user)) {
            return Collections.EMPTY_LIST;
        }
        List result = null;
        final DefaultHibernateUser defUser = (DefaultHibernateUser)user;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getGroupsForUser");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (defUser != null) {
                        queryObject.setLong(HibernateGroupManager.ENTITYID_FIELD, defUser.getId());
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return result;
    }

    protected List getGroupsForExternalEntity(final ExternalEntity externalEntity) throws RepositoryException {
        if (externalEntity == null) {
            throw new IllegalArgumentException("Input (externalEntity) is null.");
        }
        List result = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getGroupsForExternalEntity");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (externalEntity != null) {
                        queryObject.setLong(HibernateGroupManager.ENTITYID_FIELD, externalEntity.getId());
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return result;
    }

    public Pager getMemberNames(Group group) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        if (!this.isHandledGroup(group)) {
            throw new IllegalArgumentException("Group passed to HibernateGroupManager must be of type 'DefaultHibernateGroup'");
        }
        return PagerFactory.getPager(this.getExternalMemberNames(group), this.getLocalMemberNames(group));
    }

    protected void validateGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        this.validateGroup(group);
        final DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        List result = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getLocalMemberNames");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (defGroup != null) {
                        queryObject.setLong(HibernateGroupManager.GROUPID_FIELD, defGroup.getId());
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return new DefaultPager(result);
    }

    public Pager getLocalMembers(Group group) throws RepositoryException {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            return new DefaultPager();
        }
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        ArrayList result = new ArrayList(defGroup.getLocalMembers());
        return new DefaultPager(result);
    }

    private boolean isHandledGroup(Group group) {
        return group instanceof DefaultHibernateGroup;
    }

    public Pager getExternalMembers(Group group) throws RepositoryException {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            return new DefaultPager();
        }
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        ArrayList result = new ArrayList(defGroup.getExternalMembers());
        return new DefaultPager(result);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            return new DefaultPager();
        }
        final DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        List result = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getExternalMemberNames");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (defGroup != null) {
                        queryObject.setLong(HibernateGroupManager.GROUPID_FIELD, defGroup.getId());
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return new DefaultPager(result);
    }

    public Group getGroup(final String groupname) throws EntityException {
        if (groupname == null) {
            throw new IllegalArgumentException("Input (groupname) is null.");
        }
        List result = null;
        Group foundGroup = null;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_find");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateGroupManager.this.getSessionFactory());
                    if (groupname != null) {
                        queryObject.setParameter(HibernateGroupManager.GROUPNAME_FIELD, (Object)groupname);
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        try {
            foundGroup = (Group)result.get(0);
        }
        catch (Exception e) {
            return foundGroup;
        }
        return foundGroup;
    }

    public Group createGroup(String groupname) throws EntityException {
        if (groupname == null) {
            throw new IllegalArgumentException("Input (groupname) is null.");
        }
        Group group = this.getGroup(groupname);
        if (group != null) {
            throw new DuplicateEntityException("Group [" + groupname + "] already exists in this repository (" + this.repository.getName() + ")");
        }
        group = new DefaultHibernateGroup(groupname);
        this.getHibernateTemplate().save((Object)group);
        return group;
    }

    public void removeGroup(Group group) throws EntityException {
        Iterator membersIter;
        if (group == null) {
            throw new IllegalArgumentException("Input (group) is null.");
        }
        if (!this.isHandledGroup(group)) {
            throw new IllegalArgumentException("Group is not a Hibernate entity [" + group.getClass().getName());
        }
        DefaultHibernateGroup dGroup = (DefaultHibernateGroup)group;
        Set extMembers = dGroup.getExternalMembers();
        Set localMembers = dGroup.getLocalMembers();
        dGroup.setExternalMembers(null);
        dGroup.setLocalMembers(null);
        if (extMembers != null) {
            membersIter = extMembers.iterator();
            while (membersIter.hasNext()) {
                DefaultHibernateExternalEntity entity = (DefaultHibernateExternalEntity)membersIter.next();
                Set entityGroups = entity.getGroups();
                if (entityGroups == null) continue;
                entityGroups.remove(group);
            }
        }
        if (localMembers != null) {
            membersIter = localMembers.iterator();
            while (membersIter.hasNext()) {
                DefaultHibernateUser user = (DefaultHibernateUser)membersIter.next();
                Set userGroups = user.getGroups();
                if (userGroups == null) continue;
                userGroups.remove(group);
            }
        }
        this.getHibernateTemplate().delete((Object)group);
    }

    public void addMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup dGroup = (DefaultHibernateGroup)group;
        Set<ExternalEntity> membership = null;
        Entity member = null;
        if (this.isUserExternal(user)) {
            DefaultHibernateExternalEntity dEntity;
            HashSet<DefaultHibernateGroup> extEntityGroups;
            membership = dGroup.getExternalMembers();
            if (membership == null) {
                membership = new HashSet<ExternalEntity>();
                dGroup.setExternalMembers(membership);
            }
            if ((extEntityGroups = (dEntity = (DefaultHibernateExternalEntity)(member = this.getCorrespondingExternalEntity(user))).getGroups()) == null) {
                extEntityGroups = new HashSet<DefaultHibernateGroup>();
                dEntity.setGroups(extEntityGroups);
            }
            extEntityGroups.add(dGroup);
        } else {
            DefaultHibernateUser dUser;
            HashSet<DefaultHibernateGroup> usersGroups;
            membership = dGroup.getLocalMembers();
            if (membership == null) {
                membership = new HashSet();
                dGroup.setLocalMembers(membership);
            }
            if ((usersGroups = (dUser = (DefaultHibernateUser)user).getGroups()) == null) {
                usersGroups = new HashSet<DefaultHibernateGroup>();
                dUser.setGroups(usersGroups);
            }
            usersGroups.add(dGroup);
            member = user;
        }
        membership.add((ExternalEntity)member);
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)dGroup);
            this.getHibernateTemplate().saveOrUpdate((Object)member);
            this.getSession().flush();
        }
        catch (HibernateException e) {
            throw new EntityException(e);
        }
    }

    protected ExternalEntity getCorrespondingExternalEntity(User user) throws RepositoryException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        ExternalEntity result = this.externalEntityDao.getExternalEntity(user.getName());
        if (result == null) {
            return this.createExternalEntity(user);
        }
        return result;
    }

    protected ExternalEntity createExternalEntity(User user) {
        DefaultHibernateExternalEntity entity = new DefaultHibernateExternalEntity();
        entity.setName(user.getName());
        entity.setType(user.getClass().getName());
        this.externalEntityDao.saveExternalEntity(entity);
        return entity;
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        if (this.isUserExternal(user)) {
            return this.hasExternalMembership(defGroup, user);
        }
        return this.hasLocalMembership(defGroup, (DefaultHibernateUser)user);
    }

    protected void validateGroupAndUser(Group group, User user) throws EntityException {
        if (this.getGroup(group.getName()) == null) {
            throw new IllegalArgumentException("Group unknown: [" + group + "] in [" + this.repository.getKey() + "]");
        }
        if (user == null) {
            throw new IllegalArgumentException("User unknown: [" + user + "] in [" + this.repository.getKey() + "]");
        }
        if (!this.isHandledGroup(group)) {
            throw new IllegalArgumentException("Group is not a Hibernate entity [" + group.getClass().getName());
        }
    }

    protected boolean hasExternalMembership(DefaultHibernateGroup defGroup, User user) throws EntityException {
        ExternalEntity entity = this.getCorrespondingExternalEntity(user);
        Set userGroups = ((DefaultHibernateExternalEntity)entity).getGroups();
        return userGroups != null && userGroups.contains(defGroup);
    }

    protected boolean hasLocalMembership(DefaultHibernateGroup defGroup, DefaultHibernateUser defUser) throws EntityException {
        Set usersGroups = defUser.getGroups();
        return usersGroups != null && usersGroups.contains(defGroup);
    }

    public void removeMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup hibernateGroup = (DefaultHibernateGroup)group;
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        if (this.isUserExternal(user)) {
            hibernateGroup.getExternalMembers().remove(user);
            ExternalEntity extUser = this.getCorrespondingExternalEntity(user);
            ((DefaultHibernateExternalEntity)extUser).getGroups().remove(group);
            hibernateTemplate.saveOrUpdate((Object)extUser);
        } else {
            hibernateGroup.getLocalMembers().remove(user);
            ((DefaultHibernateUser)user).getGroups().remove(group);
            hibernateTemplate.saveOrUpdate((Object)user);
        }
        hibernateTemplate.saveOrUpdate((Object)group);
        hibernateTemplate.flush();
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return this.getGroup(group.getName()) == null;
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (HibernateRepository)args.get("repository");
        this.userManager = (UserManager)args.get("userManager");
        this.externalEntityDao = (ExternalEntityDAO)args.get("externalEntityDAO");
        this.setSessionFactory(this.repository.getSessionFactory());
        InitializationCheck.validateArgs(args, new String[]{"repository", "userManager", "externalEntityDAO"}, this);
    }
}

