/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.HibernateGroupManager;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;

public class HibernateLocalUserGroupManager
extends HibernateGroupManager {
    public HibernateLocalUserGroupManager() {
    }

    public HibernateLocalUserGroupManager(HibernateRepository repository, UserManager userManager) {
        this.repository = repository;
        this.userManager = userManager;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (HibernateRepository)args.get("repository");
        this.userManager = (UserManager)args.get("userManager");
        this.setSessionFactory(this.repository.getSessionFactory());
        InitializationCheck.validateArgs(args, new String[]{"repository", "userManager"}, this);
    }

    public Pager getGroups(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        List groups = this.getGroupsForLocalUser(user);
        return new DefaultPager(groups);
    }

    public Pager getMemberNames(Group group) throws EntityException {
        this.validateGroup(group);
        if (this.getGroup(group.getName()) == null) {
            return null;
        }
        Pager members = this.getLocalMemberNames(group);
        return members;
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return Pager.EMPTY_PAGER;
    }

    public void addMembership(Group group, User user) throws EntityException {
        DefaultHibernateUser dUser;
        HashSet<DefaultHibernateGroup> usersGroups;
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup dGroup = (DefaultHibernateGroup)group;
        User member = null;
        HashSet<User> membership = dGroup.getLocalMembers();
        if (membership == null) {
            membership = new HashSet<User>();
            dGroup.setLocalMembers(membership);
        }
        if ((usersGroups = (dUser = (DefaultHibernateUser)user).getGroups()) == null) {
            usersGroups = new HashSet<DefaultHibernateGroup>();
            dUser.setGroups(usersGroups);
        }
        usersGroups.add(dGroup);
        member = user;
        membership.add(member);
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)dGroup);
            this.getHibernateTemplate().saveOrUpdate((Object)member);
            this.getSession().flush();
        }
        catch (HibernateException e) {
            throw new EntityException(e);
        }
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        DefaultHibernateUser defUser = (DefaultHibernateUser)user;
        return this.hasLocalMembership(defGroup, defUser);
    }

    public void removeMembership(Group group, User user) throws EntityException {
        this.validateGroupAndUser(group, user);
        DefaultHibernateGroup defGroup = (DefaultHibernateGroup)group;
        User member = user;
        Set membership = defGroup.getLocalMembers();
        if (membership != null) {
            membership.remove(member);
            this.getHibernateTemplate().saveOrUpdate((Object)defGroup);
            this.getHibernateTemplate().flush();
        }
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }
}

