/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate.properties;

import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.impl.hibernate.properties.HibernatePropertySetFactory;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.HashMap;

public class HibernateExternalEntityPropertySetFactory
extends HibernatePropertySetFactory {
    public HibernateExternalEntityPropertySetFactory() {
    }

    public HibernateExternalEntityPropertySetFactory(ExternalEntityDAO externalEntityDAO, HibernateRepository repository) {
        this.repository = repository;
        this.externalEntityDAO = externalEntityDAO;
    }

    protected PropertySet getPropertySet(String entityName) throws EntityException {
        PropertySet propertySet = null;
        HashMap<String, Object> args = new HashMap<String, Object>();
        ExternalEntity externalEntity = this.externalEntityDAO.getExternalEntity(entityName);
        if (externalEntity == null) {
            externalEntity = new DefaultHibernateExternalEntity();
            ((DefaultHibernateExternalEntity)externalEntity).setName(entityName);
            ((DefaultHibernateExternalEntity)externalEntity).setType("EXT");
            this.externalEntityDAO.saveExternalEntity(externalEntity);
        }
        args.put("entityId", new Long(externalEntity.getId()));
        args.put("entityName", externalEntity.getType() + "_" + externalEntity.getName());
        args.put("configurationProvider", this.repository.getHibernateConfigurationProvider());
        propertySet = this.getPropertySet(args);
        return propertySet;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.externalEntityDAO = (ExternalEntityDAO)args.get("externalEntityDAO");
        this.repository = (HibernateRepository)args.get("repository");
        InitializationCheck.validateArgs(args, new String[]{"repository", "externalEntityDAO"}, this);
    }
}

