/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.ReadOnlyGroupManager;
import com.atlassian.user.impl.ldap.LDAPValidator;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import java.util.HashMap;

public class LDAPGroupManagerReadOnly
extends ReadOnlyGroupManager {
    private LDAPRepository repository;
    private LDAPGroupAdaptor groupAdaptor;

    public LDAPGroupManagerReadOnly() {
    }

    public LDAPGroupManagerReadOnly(LDAPRepository repository, LDAPGroupAdaptor groupAdaptor) {
        this.repository = repository;
        this.groupAdaptor = groupAdaptor;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        this.groupAdaptor = (LDAPGroupAdaptor)args.get("groupAdaptor");
        InitializationCheck.validateArgs(args, new String[]{"repository", "groupAdaptor"}, this);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public Pager getGroups() throws EntityException {
        return this.groupAdaptor.getGroups();
    }

    public Group getGroup(String groupName) throws EntityException {
        return this.groupAdaptor.getGroup(groupName);
    }

    public Pager getGroups(User user) throws EntityException {
        if (!LDAPValidator.validateLDAPEntity(user)) {
            return new DefaultPager();
        }
        return this.groupAdaptor.getGroups(user);
    }

    public Pager getMemberNames(Group group) throws EntityException {
        if (!LDAPValidator.validateLDAPEntity(group)) {
            return new DefaultPager();
        }
        return this.groupAdaptor.findMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        if (!LDAPValidator.validateLDAPEntity(group)) {
            return new DefaultPager();
        }
        return this.groupAdaptor.findMembers(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        throw new UnsupportedOperationException("External membership is not supported.");
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        return this.groupAdaptor.hasMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }
}

