/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.adaptor;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.impl.EntityMissingException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPEntity;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.util.LDAPUtils;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public abstract class AbstractLDAPGroupAdaptor
implements LDAPGroupAdaptor {
    protected LDAPGroupFactory groupFactory;
    protected LDAPRepository repository;

    protected AbstractLDAPGroupAdaptor() {
    }

    protected AbstractLDAPGroupAdaptor(LDAPRepository repo, LDAPGroupFactory groupFactory) {
        this.repository = repo;
        this.groupFactory = groupFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group getGroup(String name) throws EntityException {
        Group group;
        DirContext ctx;
        block11: {
            Group group2;
            block10: {
                ctx = null;
                NamingEnumeration<SearchResult> enume = null;
                group = null;
                try {
                    try {
                        ctx = this.repository.getLDAPContext();
                        enume = ctx.search(this.repository.getBaseGroupNamespace(), this.constructGroupSearchFilter(name), this.repository.getGroupSearchControls(null));
                        if (enume == null) {
                            group2 = null;
                            Object var8_8 = null;
                            break block10;
                        }
                        while (enume.hasMoreElements()) {
                            SearchResult result = (SearchResult)enume.nextElement();
                            Attributes attrs = result.getAttributes();
                            group = this.groupFactory.getGroup(attrs, result.getName());
                        }
                        break block11;
                    }
                    catch (NamingException e) {
                        throw new RepositoryException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (ctx == null) throw throwable;
                        ctx.close();
                        throw throwable;
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                        throw new RepositoryException(e);
                    }
                }
            }
            try {}
            catch (NamingException e) {
                e.printStackTrace();
                throw new RepositoryException(e);
            }
            if (ctx == null) return group2;
            ctx.close();
            return group2;
        }
        Object var8_9 = null;
        try {}
        catch (NamingException e) {
            e.printStackTrace();
            throw new RepositoryException(e);
        }
        if (ctx == null) return group;
        ctx.close();
        return group;
    }

    public Pager getGroups() throws EntityException {
        LDAPPagerInfo ldapPagerInfo = this.getGroupEntries();
        return new LDAPEntityPager(this.repository, this.groupFactory, ldapPagerInfo);
    }

    public LDAPPagerInfo getGroupEntries() throws EntityException {
        return this.getGroupEntries("*");
    }

    public LDAPPagerInfo getGroupEntries(String groupName) throws EntityException {
        return this.getGroupEntries(groupName, null, null);
    }

    public LDAPPagerInfo getGroupEntries(String[] attributesToReturn, String additionalSearchFilter) throws EntityException {
        return this.getGroupEntries("*", attributesToReturn, additionalSearchFilter);
    }

    public LDAPPagerInfo getGroupEntries(String groupName, String[] attributesToReturn, String additionalSearchFilter) throws RepositoryException {
        String searchFilter = this.constructGroupSearchFilter(groupName, additionalSearchFilter);
        return this.search(searchFilter, attributesToReturn);
    }

    public LDAPPagerInfo search(String searchFilter) throws RepositoryException {
        return this.search(searchFilter, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LDAPPagerInfo search(String searchFilter, String[] attributesToReturn) throws RepositoryException {
        String groupSearchFilter;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_search(" + searchFilter + ")"));
        }
        DirContext ctx = null;
        if (attributesToReturn == null) {
            attributesToReturn = new String[]{this.repository.getGroupnameAttribute()};
        }
        if ((groupSearchFilter = this.repository.getGroupSearchFilter()) != null && searchFilter.indexOf(groupSearchFilter) == -1) {
            searchFilter = this.addGroupSearchFilter(searchFilter);
        }
        SearchControls ctls = this.repository.getGroupSearchControls(attributesToReturn);
        NamingEnumeration<SearchResult> groupSearchEnume = null;
        try {
            try {
                ctx = this.repository.getLDAPContext();
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.push((String)(this.getClass().getName() + "_search_JNDI_RAW_(" + searchFilter + ")"));
                }
                groupSearchEnume = ctx.search(this.repository.getBaseGroupNamespace(), searchFilter.toString(), ctls);
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.pop((String)(this.getClass().getName() + "_search_JNDI_RAW_(" + searchFilter + ")"));
                }
            }
            catch (NamingException e) {
                throw new RepositoryException(e);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (ctx == null) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (NamingException e) {
                if (!UtilTimerStack.isActive()) throw new RepositoryException(e);
                UtilTimerStack.pop((String)(this.getClass().getName() + "_search(" + searchFilter + ")"));
                throw new RepositoryException(e);
            }
        }
        try {}
        catch (NamingException e) {
            if (!UtilTimerStack.isActive()) throw new RepositoryException(e);
            UtilTimerStack.pop((String)(this.getClass().getName() + "_search(" + searchFilter + ")"));
            throw new RepositoryException(e);
        }
        if (ctx != null) {
            ctx.close();
        }
        LDAPPagerInfo info = new LDAPPagerInfo(groupSearchEnume, searchFilter.toString(), this.repository.getBaseGroupNamespace(), this.repository.isGroupSearchScopeAllDepths(), attributesToReturn);
        if (!UtilTimerStack.isActive()) return info;
        UtilTimerStack.pop((String)(this.getClass().getName() + "_search(" + searchFilter + ")"));
        return info;
    }

    protected String constructGroupSearchFilter(String name) {
        return this.constructGroupSearchFilter(name, null);
    }

    protected String constructGroupSearchFilter(String name, String patternToAnd) {
        String searchFilter = "";
        if (TextUtils.stringSet((String)name) && !"*".equals(name)) {
            searchFilter = "(" + this.repository.getGroupnameAttribute() + "=" + name + ")";
        }
        searchFilter = this.addGroupSearchFilter(searchFilter);
        if (TextUtils.stringSet((String)patternToAnd)) {
            if (LDAPUtils.isValidFitler(patternToAnd)) {
                return LDAPUtils.makeAndFilter(searchFilter, patternToAnd);
            }
            return LDAPUtils.makeAndFilter(searchFilter, "(" + patternToAnd + ")");
        }
        return searchFilter;
    }

    public String addGroupSearchFilter(String searchFilter) {
        return LDAPUtils.makeAndFilter(searchFilter, this.repository.getGroupSearchFilter());
    }

    protected String getFirstPhraseFromDN(String dn) {
        String[] rdns = dn.split(",");
        String[] firstPhrase = rdns[0].split("=");
        return firstPhrase[1];
    }

    public String getGroupDN(String groupName) throws EntityException {
        LDAPPagerInfo ldapPagerInfo = this.getGroupEntries(groupName, new String[]{"dn"}, null);
        if (ldapPagerInfo.getNamingEnumeration().hasMoreElements()) {
            SearchResult result = (SearchResult)ldapPagerInfo.getNamingEnumeration().nextElement();
            String groupDN = result.getName();
            if (groupDN.indexOf(this.repository.getBaseGroupNamespace()) == -1) {
                groupDN = groupDN + "," + this.repository.getBaseGroupNamespace();
            }
            return groupDN;
        }
        throw new EntityMissingException("Could not get DN for group [" + groupName + "]");
    }

    public String getGroupDN(Group group) throws EntityException {
        if (group instanceof LDAPEntity) {
            LDAPEntity entity = (LDAPEntity)((Object)group);
            return entity.getDistinguishedName();
        }
        throw new IllegalArgumentException("Group is not an LDAPEntity");
    }

    public LDAPGroupFactory getGroupFactory() {
        return this.groupFactory;
    }
}

