/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Category;

public abstract class AbstractPrefetchingPager
implements Pager,
Iterator {
    protected static Category log = Category.getInstance((Class)(class$com$atlassian$user$search$page$AbstractPrefetchingPager == null ? (class$com$atlassian$user$search$page$AbstractPrefetchingPager = AbstractPrefetchingPager.class$("com.atlassian.user.search.page.AbstractPrefetchingPager")) : class$com$atlassian$user$search$page$AbstractPrefetchingPager));
    protected int idx = 0;
    private List prefetched = Collections.EMPTY_LIST;
    protected int indexOfFirstItemInCurrentPage = 0;
    public boolean lastPage;
    private int preloadLimit = 100;
    static /* synthetic */ Class class$com$atlassian$user$search$page$AbstractPrefetchingPager;

    public Iterator iterator() {
        return this;
    }

    public boolean isEmpty() {
        return !this.hasNext();
    }

    public List getCurrentPage() {
        return this.prefetched;
    }

    public boolean hasNext() {
        int indexWithinPage = this.getIndexWithinPage();
        if (indexWithinPage == this.prefetched.size() && !this.lastPage) {
            this.preload();
            indexWithinPage = this.getIndexWithinPage();
        }
        return indexWithinPage < this.prefetched.size() || !this.lastPage;
    }

    protected abstract void preload();

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void preload(Iterator iterator) {
        this.prefetched = new ArrayList();
        int currentPos = 0;
        try {
            while (!this.lastPage && this.prefetched.size() < this.preloadLimit) {
                ArrayList results = new ArrayList();
                if (!iterator.hasNext()) {
                    this.lastPage = true;
                    break;
                }
                Object element = iterator.next();
                this.fetch(element, results);
                Iterator i = results.iterator();
                while (i.hasNext() && this.prefetched.size() < this.preloadLimit) {
                    Object r = i.next();
                    if (currentPos >= this.idx) {
                        this.prefetched.add(r);
                    }
                    ++currentPos;
                }
            }
            if (this.prefetched.size() < 100) {
                this.lastPage = true;
            }
        }
        catch (Exception e) {
            log.error((Object)("At index [" + this.idx + "]: " + e.getMessage()), (Throwable)e);
            this.lastPage = true;
        }
        if (currentPos < this.idx) {
            this.idx = currentPos;
            return;
        }
    }

    protected abstract List fetch(Object var1, List var2) throws EntityException;

    public void nextPage() {
        this.idx += 100;
        this.preload();
    }

    public int getIndex() {
        return this.idx;
    }

    public void skipTo(int idx) throws PagerException {
        this.idx = idx;
        this.preload();
        if (this.prefetched.size() == 0 || this.prefetched == null) {
            this.idx = -1;
        }
    }

    public boolean onLastPage() {
        return this.lastPage;
    }

    public int getIndexOfFirstItemInCurrentPage() {
        return this.indexOfFirstItemInCurrentPage;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int indexWithinPage = this.getIndexWithinPage();
        Object nextObj = this.prefetched.get(indexWithinPage);
        ++this.idx;
        return nextObj;
    }

    protected int getIndexWithinPage() {
        return this.idx - this.indexOfFirstItemInCurrentPage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

