/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.authentication.EntityAuthenticationException;
import com.atlassian.user.security.password.PasswordEncryptor;
import java.util.HashMap;

public class DefaultAuthenticator
implements Authenticator {
    private UserManager userManager;
    private PasswordEncryptor encryptor;

    public DefaultAuthenticator() {
    }

    public DefaultAuthenticator(UserManager userManager, PasswordEncryptor encryptor) {
        this.userManager = userManager;
        this.encryptor = encryptor;
    }

    public boolean authenticate(String username, String password) throws EntityException {
        User user = this.userManager.getUser(username);
        try {
            if (user instanceof DefaultUser) {
                return ((DefaultUser)user).getPassword().equals(this.encryptor.encrypt(password));
            }
        }
        catch (Exception e) {
            throw new EntityAuthenticationException(e);
        }
        return false;
    }

    public Repository getRepository() {
        return this.userManager.getRepository();
    }

    public void init(HashMap args) throws ConfigurationException {
        this.userManager = (UserManager)args.get("userManager");
        this.encryptor = (PasswordEncryptor)args.get("passwordEncryptor");
        InitializationCheck.validateArgs(args, new String[]{"userManager", "passwordEncryptor"}, this);
    }
}

