/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.graphviz;

import com.atlassian.confluence.servlet.download.ExportDownload;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.v2.macro.MacroException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Category;

public class DotRunner {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$confluence$extra$graphviz$DotRunner == null ? (class$com$atlassian$confluence$extra$graphviz$DotRunner = DotRunner.class$("com.atlassian.confluence.extra.graphviz.DotRunner")) : class$com$atlassian$confluence$extra$graphviz$DotRunner));
    private File outputFile = null;
    private String outputPath = null;
    private StringBuffer output;
    private String verifiedDotExecutableName = null;
    private int exitCode;
    private String error;
    static /* synthetic */ Class class$com$atlassian$confluence$extra$graphviz$DotRunner;

    public String getOutputUrl() {
        return ExportDownload.getUrl((File)this.outputFile, (String)"image/gif");
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getError() {
        return this.error;
    }

    public DotRunner(String format, String commands, boolean createFile) throws MacroException {
        if (createFile) {
            try {
                this.outputFile = ExportDownload.createTempFile((String)"graphviz", (String)("." + format));
                this.outputPath = this.outputFile.getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new MacroException("Couldn't open temporary file", (Throwable)ioe);
            }
        }
        Process p = null;
        String executableName = this.findValidDotName();
        if (executableName == null) {
            throw new MacroException("No useable executable name defined in graphviz.properties");
        }
        try {
            String line;
            String[] args;
            if (createFile) {
                args = new String[3];
                args[2] = "-o" + this.outputPath;
            } else {
                args = new String[]{executableName, "-T" + format};
            }
            p = Runtime.getRuntime().exec(args);
            OutputStream dotStdin = p.getOutputStream();
            dotStdin.write(commands.getBytes());
            dotStdin.close();
            if (!createFile) {
                this.output = new StringBuffer();
                BufferedReader dotStdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
                line = dotStdout.readLine();
                while (line != null) {
                    this.output.append(line);
                    line = dotStdout.readLine();
                }
            }
            while (true) {
                try {
                    this.exitCode = p.waitFor();
                    if (this.exitCode != 0) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        this.error = "";
                        line = reader.readLine();
                        while (line != null) {
                            this.error = this.error + line;
                            line = reader.readLine();
                        }
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new MacroException("Couldn't run '" + this.verifiedDotExecutableName + "', make sure it is in your PATH", (Throwable)ioe);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private String findValidDotName() {
        if (this.verifiedDotExecutableName == null) {
            Properties p = GeneralUtil.getProperties((String)"graphviz.properties", (Class)(class$com$atlassian$confluence$extra$graphviz$DotRunner == null ? (class$com$atlassian$confluence$extra$graphviz$DotRunner = DotRunner.class$("com.atlassian.confluence.extra.graphviz.DotRunner")) : class$com$atlassian$confluence$extra$graphviz$DotRunner));
            String dotExecutableName = p.getProperty("dot.executable.name");
            if (dotExecutableName != null) {
                this.verifiedDotExecutableName = dotExecutableName;
            } else {
                String namesToTry = p.getProperty("dot.candidate.paths");
                if (namesToTry == null) {
                    return null;
                }
                String[] names = namesToTry.split(",");
                for (int i = 0; i < names.length; ++i) {
                    try {
                        String[] args = new String[]{names[i], "-V"};
                        Process proc = Runtime.getRuntime().exec(args);
                        proc.destroy();
                        this.verifiedDotExecutableName = names[i];
                        break;
                    }
                    catch (IOException ioe) {
                        log.info((Object)("dot path " + names[i] + " failed, trying next path."));
                        continue;
                    }
                }
            }
        }
        return this.verifiedDotExecutableName;
    }

    public String getOutput() {
        return this.output.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

