/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.graphviz;

import com.atlassian.confluence.extra.graphviz.DotRunner;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GraphVizHelper {
    private static int imageMapId = 0;

    public static String generateGraph(String dotCommands, int startLine, int endSkip, SubRenderer subRenderer, RenderContext context) throws MacroException {
        DotRunner dotRunner;
        String imageMap = "";
        String mapName = null;
        if (dotCommands.indexOf("URL=") != -1) {
            dotCommands = GraphVizHelper.evaluateLinks(dotCommands, subRenderer, context);
            mapName = "spaceGraph" + imageMapId++;
            imageMap = GraphVizHelper.generateImageMap(dotCommands);
            imageMap = imageMap.replaceAll("_anonymous_0", mapName) + "\n";
        }
        if ((dotRunner = new DotRunner("gif", dotCommands, true)).getExitCode() != 0) {
            String error = dotRunner.getError();
            if (error.indexOf("syntax error near line") != -1) {
                String[] bits = error.split(":");
                int lineNo = Integer.parseInt(bits[2]) - 1;
                String[] lines = dotCommands.split("\n");
                String message = "Syntax Error: " + bits[4] + "<br/>\n";
                for (int i = startLine; i < lines.length - endSkip; ++i) {
                    if (i == lineNo) {
                        message = message + "<span style=\"background-color: #FF8080\">";
                    }
                    message = message + lines[i];
                    if (i == lineNo) {
                        message = message + "</span>";
                    }
                    message = message + "</br>\n";
                }
                error = message;
            }
            return "<div class=errorBox>\n" + error + "\n</div>";
        }
        return imageMap + "<img src='" + dotRunner.getOutputUrl() + "'" + (mapName != null ? " usemap=\"#" + mapName + "\"" : "") + "/>";
    }

    private static String evaluateLinks(String dotCommands, SubRenderer subRenderer, RenderContext context) {
        Pattern linkPattern = Pattern.compile("URL=\"(\\[[^\\]]+\\])\"");
        Pattern hrefPattern = Pattern.compile("href=\"([^\"]+)\"");
        Matcher m = linkPattern.matcher(dotCommands);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String group = m.group(1);
            String linkHtml = subRenderer.render(group, context);
            Matcher m2 = hrefPattern.matcher(linkHtml);
            String replacement = group;
            if (m2.find()) {
                replacement = "URL=\"" + m2.group(1) + "\"";
            }
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String generateImageMap(String dotCommands) throws MacroException {
        DotRunner dotRunner = new DotRunner("cmapx", dotCommands, false);
        if (dotRunner.getExitCode() != 0) {
            throw new MacroException("Failed to create image map:" + dotRunner.getError());
        }
        return dotRunner.getOutput();
    }
}

