/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.index;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.index.BatchOpIndexer;
import com.atlassian.bonnie.index.NoOpProgressWrapper;
import com.atlassian.bonnie.index.ObjectQueue;
import com.atlassian.bonnie.index.QueueProcessingRunnableImpl;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.core.util.ProgressWrapper;
import java.io.IOException;
import org.apache.log4j.Category;

public abstract class BaseMultiThreadedIndexer
implements BatchOpIndexer {
    protected static Category log = Category.getInstance((Class)BaseMultiThreadedIndexer.class);
    protected LuceneConnection luceneConnection;
    private boolean reindexing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reindex(ObjectQueue queue, BatchOpIndexer.DocumentWritingScheme documentWritingScheme, ProgressMeter meter, boolean truncate) {
        try {
            this.reindexing = true;
            int numThreads = this.calculateNumberOfThreads(queue.size());
            ProgressWrapper progress = meter != null ? new ProgressWrapper(meter, queue.size()) : NoOpProgressWrapper.INSTANCE;
            documentWritingScheme.setProgressWrapper(progress);
            PooledExecutor executor = new PooledExecutor(numThreads + 5);
            executor.createThreads(numThreads);
            Runnable r = this.getQueueProcessingRunnable(queue, documentWritingScheme);
            int x = executor.getPoolSize();
            for (int i = 0; i < x; ++i) {
                try {
                    executor.execute(r);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error((Object)("Problem in parallelising indexing? " + e), (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pool size=" + executor.getPoolSize()));
            }
            executor.shutdownAfterProcessingCurrentlyQueuedTasks();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for queue to shutdown...");
            }
            try {
                executor.awaitTerminationAfterShutdown();
            }
            catch (InterruptedException e) {
                log.error((Object)("Problem in parallelising indexing? " + e), (Throwable)e);
            }
            progress.setPercentage(99);
            progress.setStatus("Finished reindexing " + progress.getTotal() + " objects.");
            this.allThreadsComplete(documentWritingScheme, truncate);
        }
        finally {
            this.reindexing = false;
        }
    }

    protected Runnable getQueueProcessingRunnable(ObjectQueue queue, BatchOpIndexer.DocumentWritingScheme documentWritingScheme) {
        return new QueueProcessingRunnableImpl(queue, documentWritingScheme);
    }

    public void truncateIndex() throws IOException {
        this.luceneConnection.truncateIndex();
    }

    protected abstract void allThreadsComplete(BatchOpIndexer.DocumentWritingScheme var1, boolean var2);

    protected int calculateNumberOfThreads(int numObjects) {
        if (numObjects < 10) {
            return 1;
        }
        if (numObjects < 100) {
            return 3;
        }
        if (numObjects < 500) {
            return 5;
        }
        return 10;
    }

    protected boolean isReindexing() {
        return this.reindexing;
    }

    public void setReindexing(boolean reindexing) {
        this.reindexing = reindexing;
    }
}

