/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.index;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class TempIndexWriter {
    protected static Category log = Category.getInstance((Class)TempIndexWriter.class);
    private final Map writers = Collections.synchronizedMap(new HashMap());
    private Analyzer analyzerForIndexing;
    private String tmpDir;

    public TempIndexWriter(Analyzer analyzerForIndexing, String tmpDir) {
        this.analyzerForIndexing = analyzerForIndexing;
        this.tmpDir = tmpDir;
    }

    public void addDocument(String key, Document doc) throws IOException {
        WriterData writerData = (WriterData)this.writers.get(key);
        if (writerData == null) {
            writerData = this.createData();
            this.writers.put(key, writerData);
        }
        writerData.writer.addDocument(doc);
    }

    public void close(String prefix) throws IOException {
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            WriterData writerData;
            String key = it.next().toString();
            if (!key.startsWith(prefix) || (writerData = (WriterData)this.writers.get(key)) == null) continue;
            this.delete(writerData.tmpIndexDir);
        }
    }

    public void closeAll() throws IOException {
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            WriterData writerData = (WriterData)this.writers.get(it.next());
            this.delete(writerData.tmpIndexDir);
        }
        this.writers.clear();
    }

    public void merge(IndexWriter writer) throws IOException {
        LinkedList<Directory> indexDirectories = new LinkedList<Directory>();
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            WriterData writerData = (WriterData)this.writers.get(it.next());
            writerData.writer.close();
            indexDirectories.add(writerData.dir);
        }
        writer.addIndexes(indexDirectories.toArray(new Directory[indexDirectories.size()]));
    }

    public void merge(String prefix, IndexWriter writer) throws IOException {
        LinkedList<Directory> indexDirectories = new LinkedList<Directory>();
        Iterator it = this.writers.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.startsWith(prefix)) continue;
            WriterData writerData = (WriterData)this.writers.get(key);
            writerData.writer.close();
            indexDirectories.add(writerData.dir);
        }
        System.out.println("Index directories:" + indexDirectories);
        if (indexDirectories.size() > 0) {
            writer.addIndexes(indexDirectories.toArray(new Directory[indexDirectories.size()]));
        }
    }

    protected final boolean delete(File directory) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].delete()) continue;
            log.error((Object)("Failed to delete index file: " + files[i].getAbsolutePath()));
            return false;
        }
        return directory.delete();
    }

    private WriterData createData() throws IOException {
        File tmpIndexDir;
        File file = tmpIndexDir = this.getTmpDir() == null ? File.createTempFile("lucene", "index") : File.createTempFile("lucene", "index", new File(this.getTmpDir()));
        if (!tmpIndexDir.delete() || !tmpIndexDir.mkdirs()) {
            throw new IOException("Unable to create temporary index directory: " + tmpIndexDir);
        }
        FSDirectory dir = FSDirectory.getDirectory((File)tmpIndexDir, (boolean)true);
        new IndexWriter((Directory)dir, null, true).close();
        IndexWriter writer = new IndexWriter((Directory)dir, this.analyzerForIndexing, false);
        writer.mergeFactor = 50;
        writer.minMergeDocs = 300;
        writer.maxMergeDocs = Integer.MAX_VALUE;
        return new WriterData(writer, (Directory)dir, tmpIndexDir);
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    protected class WriterData {
        IndexWriter writer;
        Directory dir;
        File tmpIndexDir;

        protected WriterData(IndexWriter writer, Directory dir, File tmpIndexDir) {
            this.writer = writer;
            this.dir = dir;
            this.tmpIndexDir = tmpIndexDir;
        }
    }
}

