/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle;

import com.atlassian.paddle.Arguments;
import com.atlassian.paddle.configuration.AtlassianUserConfiguration;
import com.atlassian.paddle.configuration.ConfigurationException;
import com.atlassian.paddle.connection.ConnectionException;
import com.atlassian.paddle.connection.DefaultConnectionFactory;
import com.atlassian.paddle.connection.DefaultConnectionProperties;
import com.atlassian.paddle.task.ConnectionTestTask;
import com.atlassian.paddle.task.DefaultTaskRunner;
import com.atlassian.paddle.task.ListGroupsTask;
import com.atlassian.paddle.task.ListUsersTask;
import java.io.File;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Paddle {
    private static final long BATCH_SIZE = 10L;
    private static final int DEFAULT_COUNT_LIMIT = 10;
    private static final Logger log = Logger.getLogger(class$com$atlassian$paddle$Paddle == null ? (class$com$atlassian$paddle$Paddle = Paddle.class$("com.atlassian.paddle.Paddle")) : class$com$atlassian$paddle$Paddle);
    private static final double version = 2.0;
    static /* synthetic */ Class class$com$atlassian$paddle$Paddle;

    public static void main(String[] args) {
        AtlassianUserConfiguration configuration;
        Arguments arguments = new Arguments(args);
        if (arguments.contains("debug")) {
            log.setLevel(Level.DEBUG);
        }
        long countLimit = 10L;
        if (arguments.contains("limit")) {
            countLimit = Integer.parseInt(arguments.getValue("limit"));
        }
        log.info("###########################################################################################################################");
        log.info("");
        log.info("LDAP Support Tool version 2.0");
        log.info("");
        log.info("###########################################################################################################################\n");
        try {
            configuration = new AtlassianUserConfiguration(new File("atlassian-user.xml"));
        }
        catch (ConfigurationException e) {
            log.error("Error reading atlassian-user.xml file: " + e.getMessage(), e);
            return;
        }
        DefaultConnectionProperties properties = new DefaultConnectionProperties(configuration, 10L);
        if (properties.isAnonymousAuthentication()) {
            log.info("\nDetected that you are logging into LDAP anonymously.\n");
        }
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory(properties);
        DefaultTaskRunner taskRunner = new DefaultTaskRunner(connectionFactory);
        try {
            taskRunner.runTask(new ConnectionTestTask(), countLimit);
        }
        catch (ConnectionException e) {
            log.error("Failed to connect to LDAP server: " + e.getMessage(), e);
            return;
        }
        log.info("-----------------------------------------------------------------");
        log.info("TEST 1: Search and list " + countLimit + " users");
        log.info("-----------------------------------------------------------------\n");
        try {
            taskRunner.runTask(new ListUsersTask(configuration), countLimit);
        }
        catch (ConnectionException e) {
            throw new RuntimeException(e);
        }
        log.info("-----------------------------------------------------------------");
        log.info("TEST 2: Search and list " + countLimit + " groups");
        log.info("-----------------------------------------------------------------\n");
        try {
            taskRunner.runTask(new ListGroupsTask(configuration), countLimit);
        }
        catch (ConnectionException e) {
            throw new RuntimeException(e);
        }
        if (taskRunner.hasErrors()) {
            log.info("The following errors were encountered in running LDAP tests:");
            Iterator iterator = taskRunner.getErrorsIterator();
            while (iterator.hasNext()) {
                String errorMessage = (String)iterator.next();
                log.info("");
                log.info(errorMessage);
            }
            log.info("");
            log.info("Please submit a support ticket at http://support.atlassian.com and attach your atlassian-user.xml and the paddle.log file (located in this directory).");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

