/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.connection;

import com.atlassian.paddle.connection.ConnectionException;
import com.atlassian.paddle.connection.ConnectionFactory;
import com.atlassian.paddle.connection.ConnectionProperties;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;

public class DefaultConnectionFactory
implements ConnectionFactory {
    private final Logger logger = Logger.getLogger(this.getClass());
    private Hashtable environment;

    public DefaultConnectionFactory(ConnectionProperties properties) {
        this.environment = this.buildEnvironment(properties);
    }

    public DirContext createConnection() throws ConnectionException {
        String providerUrl = (String)this.environment.get("java.naming.provider.url");
        try {
            long start = System.currentTimeMillis();
            InitialDirContext result = new InitialDirContext(this.environment);
            long tookMillis = System.currentTimeMillis() - start;
            this.logger.debug("Connecting to LDAP server took " + tookMillis + " ms for " + providerUrl);
            return result;
        }
        catch (NamingException e) {
            throw this.createFriendlyLdapException(e, providerUrl);
        }
    }

    private ConnectionException createFriendlyLdapException(NamingException exception, String providerUrl) {
        String message = exception.getMessage();
        if (message != null && message.indexOf("error code 49") != -1) {
            return new ConnectionException("Username or password is incorrect. Please check them again.", exception);
        }
        Throwable cause = exception.getCause();
        if (cause != null && cause.getMessage() != null && cause.getMessage().indexOf("Connection refused") != -1) {
            return new ConnectionException("Connection could not be opened to server at " + providerUrl + ". " + "Please check your host and port values are correct, and the server is running.", exception);
        }
        return new ConnectionException("Failed to connect to LDAP server with provider URL " + providerUrl + ": " + exception.getMessage(), exception);
    }

    private Hashtable buildEnvironment(ConnectionProperties properties) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("java.naming.provider.url", properties.getProviderUrl());
        result.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        result.put("java.naming.security.protocol", properties.getSecurityProtocol());
        result.put("java.naming.batchsize", properties.getBatchSize());
        if (!properties.isAnonymousAuthentication()) {
            result.put("java.naming.security.principal", properties.getUsername());
            result.put("java.naming.security.credentials", properties.getPassword());
        }
        result.put("java.naming.security.authentication", properties.getSecurityAuthentication());
        return result;
    }
}

