/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.search;

import com.atlassian.paddle.configuration.Configuration;
import com.atlassian.paddle.search.AbstractSearch;
import javax.naming.directory.SearchControls;
import org.apache.log4j.Logger;

public class UsersSearch
extends AbstractSearch {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Configuration configuration;

    public UsersSearch(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getBaseDn() {
        return this.configuration.getAttributeWarnIfMissing("baseUserNamespace", this.logger);
    }

    public String getFilter() {
        return this.configuration.getAttributeWarnIfMissing("userSearchFilter", this.logger);
    }

    protected String[] getAttributesToReturn() {
        String usernameAttribute = this.configuration.getAttributeWarnIfMissing("usernameAttribute", this.logger);
        String firstnameAttribute = this.configuration.getAttributeWarnIfMissing("firstnameAttribute", this.logger);
        String surnameAttribute = this.configuration.getAttributeWarnIfMissing("surnameAttribute", this.logger);
        String emailAttribute = this.configuration.getAttributeWarnIfMissing("emailAttribute", this.logger);
        return new String[]{usernameAttribute, firstnameAttribute, surnameAttribute, emailAttribute};
    }

    public SearchControls getSearchControls() {
        SearchControls result = super.getSearchControls();
        if ("true".equalsIgnoreCase(this.configuration.getAttribute("userSearchAllDepths"))) {
            result.setSearchScope(2);
        } else {
            result.setSearchScope(1);
        }
        return result;
    }
}

