/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.task;

import com.atlassian.paddle.Group;
import com.atlassian.paddle.configuration.Configuration;
import com.atlassian.paddle.search.DefaultSearcher;
import com.atlassian.paddle.search.GroupResultConverter;
import com.atlassian.paddle.search.GroupsSearch;
import com.atlassian.paddle.search.Search;
import com.atlassian.paddle.search.SearchException;
import com.atlassian.paddle.search.Searcher;
import com.atlassian.paddle.task.Task;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.directory.DirContext;
import org.apache.log4j.Logger;

public class ListGroupsTask
implements Task {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Configuration configuration;

    public ListGroupsTask(Configuration configuration) {
        this.configuration = configuration;
    }

    public void withConnection(DirContext context, Collection errors, long countLimit) {
        DefaultSearcher searcher = new DefaultSearcher(context, countLimit);
        Collection groups = this.doSearch(searcher, errors, new GroupsSearch(this.configuration), countLimit);
        Iterator groupsIterator = groups.iterator();
        while (groupsIterator.hasNext()) {
            Group group = (Group)groupsIterator.next();
            this.logger.info(group);
        }
    }

    private Collection doSearch(Searcher searcher, Collection errors, Search search, long memberCountLimit) {
        String membershipAttribute = this.configuration.getAttributeWarnIfMissing("membershipAttribute", this.logger);
        try {
            return searcher.search(search, new GroupResultConverter(membershipAttribute, memberCountLimit));
        }
        catch (SearchException e) {
            this.logger.debug(e, e);
            errors.add(e.getMessage());
            return Collections.EMPTY_LIST;
        }
    }
}

