/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.task;

import com.atlassian.paddle.configuration.Configuration;
import com.atlassian.paddle.search.DefaultSearcher;
import com.atlassian.paddle.search.DnResultConverter;
import com.atlassian.paddle.search.GroupsForUserSearch;
import com.atlassian.paddle.search.Search;
import com.atlassian.paddle.search.SearchException;
import com.atlassian.paddle.search.Searcher;
import com.atlassian.paddle.search.UsersSearch;
import com.atlassian.paddle.task.Task;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.directory.DirContext;
import org.apache.log4j.Logger;

public class ListUsersTask
implements Task {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final Configuration configuration;

    public ListUsersTask(Configuration configuration) {
        this.configuration = configuration;
    }

    public void withConnection(DirContext context, Collection errors, long countLimit) {
        DefaultSearcher searcher = new DefaultSearcher(context, countLimit);
        Collection userDns = this.doSearch(searcher, errors, new UsersSearch(this.configuration));
        Iterator userIterator = userDns.iterator();
        while (userIterator.hasNext()) {
            String userDn = (String)userIterator.next();
            this.logger.info("User: " + userDn);
            Collection groups = this.doSearch(searcher, errors, new GroupsForUserSearch(this.configuration, userDn));
            if (groups.isEmpty()) {
                this.logger.info("\tDoes not belong to any LDAP groups.");
                this.logger.info("");
                continue;
            }
            this.logger.info("Member of:");
            Iterator groupsIterator = groups.iterator();
            while (groupsIterator.hasNext()) {
                String groupDn = (String)groupsIterator.next();
                this.logger.info("\t" + groupDn);
            }
            this.logger.info("");
        }
    }

    private Collection doSearch(Searcher searcher, Collection errors, Search search) {
        try {
            return searcher.search(search, new DnResultConverter());
        }
        catch (SearchException e) {
            this.logger.debug(e, e);
            errors.add(e.getMessage());
            return Collections.EMPTY_SET;
        }
    }
}

