/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.jira;

import bucket.cache.CacheManager;
import bucket.container.ContainerManager;
import bucket.util.FileUtils;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.radeox.macros.include.AbstractHttpRetrievalMacro;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.JiraIconMappingManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import com.atlassian.user.impl.cache.Cache;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Category;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.macro.parameter.MacroParameter;

public class JiraIssuesMacro
extends AbstractHttpRetrievalMacro {
    private Category log = Category.getInstance(((Object)((Object)this)).getClass());
    private static final String MACRO_REFRESH = "macro.refresh";
    private String[] myParamDescription = new String[]{"1: url", "?2: columns"};
    private List defaultColumns = new LinkedList();
    private CacheManager cacheManager;
    private BootstrapManager bootstrapManager;
    private GateKeeper gateKeeper;
    static /* synthetic */ Class class$com$atlassian$confluence$extra$jira$JiraIssuesMacro;

    public void setInitialContext(InitialRenderContext initialRenderContext) {
        super.setInitialContext(initialRenderContext);
        this.defaultColumns.clear();
        this.defaultColumns.add("type");
        this.defaultColumns.add("key");
        this.defaultColumns.add("summary");
        this.defaultColumns.add("assignee");
        this.defaultColumns.add("reporter");
        this.defaultColumns.add("priority");
        this.defaultColumns.add("status");
        this.defaultColumns.add("resolution");
        this.defaultColumns.add("created");
        this.defaultColumns.add("updated");
        this.defaultColumns.add("due");
    }

    public String getName() {
        return "jiraissues";
    }

    public String[] getParamDescription() {
        return this.myParamDescription;
    }

    public String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        boolean flush;
        String url = TextUtils.noNull((String)macroParameter.get("url", 0)).trim();
        url = this.cleanUrlParentheses(url);
        String columns = TextUtils.noNull((String)macroParameter.get("columns", 1)).trim();
        String count = TextUtils.noNull((String)macroParameter.get("count")).trim();
        String cacheStr = TextUtils.noNull((String)macroParameter.get("cache", 2)).trim();
        if (cacheStr.equals("")) {
            cacheStr = "true";
        }
        boolean bl = flush = Boolean.valueOf(cacheStr) == false;
        if (!flush) {
            flush = this.flushCacheParameterSet();
        }
        String refreshUrl = this.getRefreshUrl();
        Map contextMap = MacroUtils.defaultVelocityContext();
        Element channel = this.fetchChannel(url, flush);
        if (channel == null) {
            return "error";
        }
        String clickableUrl = this.makeClickableUrl(url);
        if (TextUtils.stringSet((String)macroParameter.get("baseurl"))) {
            clickableUrl = this.rebaseUrl(clickableUrl, macroParameter.get("baseurl").trim());
        }
        if ("true".equals(count)) {
            return this.countHtml(clickableUrl, channel);
        }
        contextMap.put("url", url);
        contextMap.put("clickableUrl", clickableUrl);
        contextMap.put("channel", channel);
        contextMap.put("entries", channel.getChildren("item"));
        contextMap.put("columns", this.prepareDisplayColumns(columns));
        contextMap.put("icons", this.prepareIconMap(channel));
        contextMap.put("refreshUrl", refreshUrl);
        return VelocityUtils.getRenderedTemplate((String)"templates/extra/jira/jiraissues.vm", (Map)contextMap);
    }

    public String rebaseUrl(String clickableUrl, String baseUrl) {
        return clickableUrl.replaceFirst("^.*?://[^/]+", baseUrl);
    }

    private String countHtml(String url, Element channel) {
        return "<a href=\"" + url + "\">" + channel.getChildren("item").size() + " issues</a>";
    }

    private String makeClickableUrl(String url) {
        int passwordIdx;
        int usernameIdx;
        String link = url;
        if (link.indexOf("view=rss") > 0) {
            link = link.replaceAll("view=rss", "");
        }
        if (link.indexOf("decorator=none") > 0) {
            link = link.replaceAll("decorator=none", "");
        }
        if ((usernameIdx = link.indexOf("&os_username=")) > 0) {
            int nextAmp = link.indexOf(38, usernameIdx + 1);
            link = nextAmp > 0 ? link.substring(0, usernameIdx) + link.substring(nextAmp) : link.substring(0, usernameIdx);
        }
        if ((passwordIdx = link.indexOf("&os_password=")) > 0) {
            int nextAmp = link.indexOf(38, passwordIdx + 1);
            link = nextAmp > 0 ? link.substring(0, passwordIdx) + link.substring(nextAmp) : link.substring(0, passwordIdx);
        }
        return link;
    }

    private List prepareDisplayColumns(String columns) {
        if (columns == null || columns.equals("")) {
            return this.defaultColumns;
        }
        StringTokenizer tokenizer = new StringTokenizer(columns, ",;");
        LinkedList<String> list = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            String col = tokenizer.nextToken().toLowerCase().trim();
            if (!this.defaultColumns.contains(col) || list.contains(col)) continue;
            list.add(col);
        }
        if (list.isEmpty()) {
            return this.defaultColumns;
        }
        return list;
    }

    private Map prepareIconMap(Element channel) {
        String link = channel.getChild("link").getValue().toString();
        int index = link.indexOf("/secure/IssueNavigator");
        if (index != -1) {
            link = link.substring(0, index);
        }
        String imagesRoot = link + "/images/icons/";
        HashMap result = new HashMap();
        JiraIconMappingManager iconMappingManager = (JiraIconMappingManager)ContainerManager.getComponent((String)"jiraIconMappingManager");
        Iterator iterator = iconMappingManager.getIconMappings().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String icon = (String)entry.getValue();
            if (icon.startsWith("http://") || icon.startsWith("https://")) {
                result.put(entry.getKey(), icon);
                continue;
            }
            result.put(GeneralUtil.escapeXml((String)((String)entry.getKey())), imagesRoot + icon);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Element fetchChannel(String url, boolean flushCache) throws IOException {
        Element channel;
        Object element;
        Cache cache = this.cacheManager.getCache((class$com$atlassian$confluence$extra$jira$JiraIssuesMacro == null ? (class$com$atlassian$confluence$extra$jira$JiraIssuesMacro = JiraIssuesMacro.class$("com.atlassian.confluence.extra.jira.JiraIssuesMacro")) : class$com$atlassian$confluence$extra$jira$JiraIssuesMacro).getName());
        if (flushCache) {
            try {
                cache.remove((Object)url);
            }
            catch (Exception e) {
                this.log.error((Object)("There was an error removing the JIRA Issues url (" + url + ") from the cache:"), (Throwable)e);
            }
        }
        if ((element = cache.get((Object)url)) != null) {
            byte[] webContent = (byte[])element;
            channel = this.getChannelElement(webContent, url);
            this.log.debug((Object)("XML Document feed " + url + " fetched from local cache!"));
            return channel;
        }
        this.log.debug((Object)("Fetching XML feed " + url + " ..."));
        HttpMethod method = null;
        InputStream in = null;
        try {
            int read;
            method = this.retrieveRemoteUrl(url);
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            in = method.getResponseBodyAsStream();
            byte[] bytes = new byte[1024];
            while ((read = in.read(bytes)) != -1) {
                bytesOut.write(bytes, 0, read);
            }
            byte[] webContent = bytesOut.toByteArray();
            channel = this.getChannelElement(webContent, url);
            cache.put((Object)url, (Object)webContent);
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            IOUtils.close(in);
            if (method == null) throw throwable;
            try {
                method.releaseConnection();
                throw throwable;
            }
            catch (Throwable t) {
                this.log.error((Object)"Error calling HttpMethod.releaseConnection", t);
            }
            throw throwable;
        }
        IOUtils.close((InputStream)in);
        if (method == null) return channel;
        try {}
        catch (Throwable t) {
            this.log.error((Object)"Error calling HttpMethod.releaseConnection", t);
            return channel;
        }
        method.releaseConnection();
        return channel;
    }

    private Element getChannelElement(byte[] webContent, String url) throws IOException {
        Element element;
        ByteArrayInputStream bufferedIn = null;
        try {
            bufferedIn = new ByteArrayInputStream(webContent);
            SAXBuilder saxBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            Document jdomDocument = saxBuilder.build((InputStream)bufferedIn);
            element = (Element)XPath.selectSingleNode((Object)jdomDocument, (String)"/rss//channel");
        }
        catch (JDOMException e) {
            try {
                String filename = "rssoutput" + url.hashCode() + ".txt";
                File rssParseError = new File(this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir"), filename);
                FileUtils.copyFile((InputStream)new ByteArrayInputStream(webContent), (File)rssParseError);
                String path = "/download/temp/" + filename;
                User user = this.getRemoteUser();
                if (user != null) {
                    this.gateKeeper.addKey(path, user);
                } else {
                    this.log.error((Object)"Could not reference remoteUser when trying to store results of RSS failure in temp dir.");
                }
                this.log.error((Object)"Error while trying to assemble the RSS result!", (Throwable)e);
                throw new IOException(e.getMessage() + " <a href='" + this.bootstrapManager.getWebAppContextPath() + "/download/temp/" + filename + "'>" + filename + "</a>");
            }
            catch (Throwable throwable) {
                IOUtils.close(bufferedIn);
                throw throwable;
            }
        }
        IOUtils.close((InputStream)bufferedIn);
        return element;
    }

    protected String getRefreshUrl() {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null) {
            StringBuffer refreshUrl = new StringBuffer(request.getRequestURI());
            String query = request.getQueryString();
            if (TextUtils.stringSet((String)query)) {
                refreshUrl.append("?").append(query);
                if (request.getParameter(MACRO_REFRESH) == null) {
                    refreshUrl.append("&").append(MACRO_REFRESH).append("=true");
                }
            } else {
                refreshUrl.append("?").append(MACRO_REFRESH).append("=true");
            }
            return refreshUrl.toString();
        }
        return null;
    }

    protected boolean flushCacheParameterSet() {
        String reloadParameter;
        HttpServletRequest request = ServletActionContext.getRequest();
        return request != null && (reloadParameter = request.getParameter(MACRO_REFRESH)) != null;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

