package com.atlassian.confluence.user;

import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.Group;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Category;
import bucket.container.ContainerManager;

/**
 * This authenticator adds users to confluence-users when they first log in
 */
public class ConfluenceGroupJoiningAuthenticator extends ConfluenceAuthenticator
{
    private static Category log = Category.getInstance(ConfluenceGroupJoiningAuthenticator.class);
    private GroupManager groupManager;

    public boolean login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String username, String password, boolean b) throws AuthenticatorException
    {
        boolean success = super.login(httpServletRequest, httpServletResponse, username, password, b);
        if (success)
        {
            User user = getUserAccessor().getUser(username);
            try
            {
                Group confluenceUsers = getGroupManager().getGroup("confluence-users");
                if (!getGroupManager().hasMembership(confluenceUsers, user))
                {
                    getGroupManager().addMembership(confluenceUsers, user);
                }
            }
            catch (EntityException e)
            {
                log.error("Failed to add " + username + " to confluence-users: " + e.getMessage(), e);
            }
        }
        return success;
    }

    public void setGroupManager(GroupManager groupManager)
    {
        this.groupManager = groupManager;
    }

    protected GroupManager getGroupManager()
    {
        if (groupManager == null)
            groupManager = (GroupManager) ContainerManager.getComponent("groupManager");

        return groupManager;
    }
}
