package com.atlassian.confluence.extra.userinfo;

import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.user.User;
import com.thoughtworks.xstream.XStream;
import com.opensymphony.util.TextUtils;
import org.apache.log4j.Category;

public class EditUserInfoAction extends AbstractUserProfileAction
{
    public static final Category log = Category.getInstance(EditUserInfoAction.class);

    private UserInformation userInfo = new UserInformation();
    private PersonalInformationManager personalInformationManager;
    private ContentPropertyManager contentPropertyManager;
    private XStream xStream;
    private static final String USERINFO_PROPERTY_KEY = "confluence.extra.userinfo";

    private void setUserInformation(String username, UserInformation userInformation)
    {
        contentPropertyManager.setTextProperty(personalInformationManager.getPersonalInformation(username),
                USERINFO_PROPERTY_KEY, xStream.toXML(userInformation));
    }

    private UserInformation getUserInformation(String username)
    {
        String userInfoXml = contentPropertyManager.getTextProperty(personalInformationManager.getPersonalInformation(username),
                USERINFO_PROPERTY_KEY);

        if (TextUtils.stringSet(userInfoXml))
        {
            try
            {
                return (UserInformation) xStream.fromXML(userInfoXml);
            }
            catch (Throwable t)
            {
                log.warn("Error unpacking user's personal information: " + username + ": " + t.getMessage(), t);
            }
        }

        return new UserInformation();
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager)
    {
        this.personalInformationManager = personalInformationManager;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager)
    {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setxStream(XStream xStream)
    {
        this.xStream = xStream;
    }
    
    public String doDefault() throws Exception
    {
        userInfo = getUserInformation(getRemoteUser().getName());
        return super.doDefault();
    }

    public String execute() throws Exception
    {
        setUserInformation(getRemoteUser().getName(), userInfo);
        return super.execute();
    }

    public UserInformation getUserInfo()
    {
        return userInfo;
    }
}

