/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.MergedPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.util.profiling.UtilTimerStack;
import org.apache.log4j.Logger;

public class DelegatingGroupManager
implements GroupManager {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$delegation$DelegatingGroupManager == null ? (class$com$atlassian$user$impl$delegation$DelegatingGroupManager = DelegatingGroupManager.class$("com.atlassian.user.impl.delegation.DelegatingGroupManager")) : class$com$atlassian$user$impl$delegation$DelegatingGroupManager));
    private final GroupManager leftGroupManager;
    private final GroupManager rightGroupManager;
    static /* synthetic */ Class class$com$atlassian$user$impl$delegation$DelegatingGroupManager;

    public DelegatingGroupManager(GroupManager creationGroupManager, GroupManager otherGroupManager) {
        this.leftGroupManager = creationGroupManager;
        this.rightGroupManager = otherGroupManager;
    }

    public Pager getGroups() throws EntityException {
        Pager leftPager = null;
        Pager rightPager = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroups"));
        }
        log.debug((Object)".");
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroups__left"));
            }
            leftPager = this.leftGroupManager.getGroups();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroups__left"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroups__right"));
            }
            rightPager = this.rightGroupManager.getGroups();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroups__right"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroups"));
        }
        return new MergedPager(leftPager, rightPager);
    }

    public Pager getGroups(User user) throws EntityException {
        Pager leftPager = null;
        Pager rightPager = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroups(" + user + ")"));
        }
        log.debug((Object)(" - " + user.getName()));
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroups(" + user + ")__left"));
            }
            leftPager = this.leftGroupManager.getGroups(user);
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroups(" + user + ")__left"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroups(" + user + ")__right"));
            }
            rightPager = this.rightGroupManager.getGroups(user);
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroups(" + user + ")__right"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroups(" + user + ")"));
        }
        return new MergedPager(leftPager, rightPager);
    }

    public Pager getMemberNames(Group group) throws EntityException {
        Pager result = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getMemberNames"));
        }
        log.debug((Object)".");
        try {
            result = this.leftGroupManager.getMemberNames(group);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        if (result == null || result.isEmpty()) {
            try {
                result = this.rightGroupManager.getMemberNames(group);
            }
            catch (EntityException e) {
                log.error((Object)e.getMessage());
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getMemberNames"));
        }
        return result;
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        Pager result = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getLocalMembers"));
        }
        log.debug((Object)".");
        result = this.leftGroupManager.getLocalMemberNames(group);
        if (result == null || result.isEmpty()) {
            result = this.rightGroupManager.getLocalMemberNames(group);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getLocalMembers"));
        }
        return result;
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        Pager result = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getExternalMembers"));
        }
        log.debug((Object)".");
        if (this.leftGroupManager.supportsExternalMembership()) {
            result = this.leftGroupManager.getExternalMemberNames(group);
        }
        if ((result == null || result.isEmpty()) && this.rightGroupManager.supportsExternalMembership() && result == null) {
            result = this.rightGroupManager.getExternalMemberNames(group);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getExternalMembers"));
        }
        return result;
    }

    public Group getGroup(String groupname) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroup(" + groupname + ")"));
        }
        log.debug((Object)(" - " + groupname));
        Group group = this.leftGroupManager.getGroup(groupname);
        if (group == null) {
            group = this.rightGroupManager.getGroup(groupname);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroup(" + groupname + ")"));
        }
        return group;
    }

    public Group createGroup(String groupname) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_createGroup(" + groupname + ")"));
        }
        Group newGroup = null;
        log.debug((Object)(" - " + groupname));
        Group preexistingGroup = this.getGroup(groupname);
        if (preexistingGroup != null) {
            Repository repo = this.getRepository(preexistingGroup);
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_createGroup(" + groupname + ")"));
            }
            throw new DuplicateEntityException("Group [" + groupname + "] already exists [" + repo.getName() + "]");
        }
        if (this.leftGroupManager.isCreative()) {
            newGroup = this.leftGroupManager.createGroup(groupname);
        } else if (this.rightGroupManager.isCreative()) {
            newGroup = this.rightGroupManager.createGroup(groupname);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_createGroup(" + groupname + ")"));
        }
        if (newGroup == null) {
            throw new UnsupportedOperationException("Tried to create a group in a manager which cannot create entities.");
        }
        return newGroup;
    }

    public void removeGroup(Group group) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_removeGroup(" + group + ")"));
        }
        log.debug((Object)(" - " + group.getName()));
        this.getManagerForGroup(group).removeGroup(group);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_removeGroup(" + group + ")"));
        }
    }

    public void addMembership(Group group, User user) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_addMembership(" + group + ", " + user + ")"));
        }
        log.debug((Object)(" - " + group.getName() + ", " + user.getName()));
        this.getManagerForGroup(group).addMembership(group, user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_addMembership(" + group + ", " + user + ")"));
        }
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_hasMembership(" + group + ", " + user + ")"));
        }
        log.debug((Object)(" - " + group.getName() + ", " + user.getName()));
        boolean member = this.getManagerForGroup(group).hasMembership(group, user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_hasMembership(" + group + ", " + user + ")"));
        }
        return member;
    }

    public void removeMembership(Group group, User user) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_removeMembership(" + group + ", " + user + ")"));
        }
        log.debug((Object)(" - " + group.getName() + ", " + user.getName()));
        this.getManagerForGroup(group).removeMembership(group, user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_removeMembership(" + group + ", " + user + ")"));
        }
    }

    public Repository getRepository() {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getRepository()"));
        }
        log.debug((Object)".");
        DelegatingRepository repo = new DelegatingRepository(this.leftGroupManager.getRepository(), this.rightGroupManager.getRepository());
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getRepository()"));
        }
        return repo;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getRepository(" + entity + ")"));
        }
        log.debug((Object)".");
        GroupManager gm = this.getManagerForGroup((Group)entity);
        if (gm == null) {
            return null;
        }
        Repository repo = gm.getRepository(entity);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getRepository(" + entity + ")"));
        }
        return repo;
    }

    public boolean isCreative() {
        boolean creative;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_isCreative"));
        }
        boolean bl = creative = this.leftGroupManager.isCreative() || this.rightGroupManager.isCreative();
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_isCreative"));
        }
        return creative;
    }

    public boolean supportsExternalMembership() throws EntityException {
        boolean supportsExternality;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_supportsExternalMembership"));
        }
        log.debug((Object)".");
        boolean bl = supportsExternality = this.leftGroupManager.supportsExternalMembership() || this.rightGroupManager.supportsExternalMembership();
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_supportsExternalMembership"));
        }
        return supportsExternality;
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return this.getManagerForGroup(group).isReadOnly(group);
    }

    private GroupManager getManagerForGroup(Group group) throws EntityException {
        if (this.leftGroupManager.getGroup(group.getName()) != null) {
            return this.leftGroupManager;
        }
        if (this.rightGroupManager.getGroup(group.getName()) != null) {
            return this.rightGroupManager;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

