/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.ExternalEntity;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.EntityMissingException;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.MergedPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;
import com.atlassian.util.profiling.UtilTimerStack;
import org.apache.log4j.Logger;

public class DelegatingUserManager
implements UserManager {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$delegation$DelegatingUserManager == null ? (class$com$atlassian$user$impl$delegation$DelegatingUserManager = DelegatingUserManager.class$("com.atlassian.user.impl.delegation.DelegatingUserManager")) : class$com$atlassian$user$impl$delegation$DelegatingUserManager));
    private UserManager leftUserManager;
    private UserManager rightUserManager;
    static /* synthetic */ Class class$com$atlassian$user$impl$delegation$DelegatingUserManager;

    public DelegatingUserManager(UserManager creationUserManager, UserManager otherUserManager) {
        this.leftUserManager = creationUserManager;
        this.rightUserManager = otherUserManager;
    }

    public Pager getUsers() throws EntityException {
        Pager leftPager = null;
        Pager rightPager = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUsers"));
        }
        log.debug((Object)".");
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUsers__left"));
            }
            leftPager = this.leftUserManager.getUsers();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers__left"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUsers__right"));
            }
            rightPager = this.rightUserManager.getUsers();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers__right"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        MergedPager pager = new MergedPager(leftPager, rightPager);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers"));
        }
        return pager;
    }

    public Pager getUserNames() throws EntityException {
        Pager leftPager = null;
        Pager rightPager = null;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames"));
        }
        log.debug((Object)".");
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames__left"));
            }
            leftPager = this.leftUserManager.getUserNames();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUserNames__left"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        try {
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames__right"));
            }
            rightPager = this.rightUserManager.getUserNames();
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUserNames__right"));
            }
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        MergedPager pager = new MergedPager(leftPager, rightPager);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUsers"));
        }
        return pager;
    }

    public User getUser(String username) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getUser__" + username));
        }
        log.debug((Object)(" - " + username));
        User user = this.leftUserManager.getUser(username);
        if (user == null) {
            user = this.rightUserManager.getUser(username);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getUser__" + username));
        }
        return user;
    }

    public User createUser(String username) throws UnsupportedOperationException, EntityException {
        User preexistingUser = null;
        log.debug((Object)(" - " + username));
        try {
            preexistingUser = this.getUser(username);
        }
        catch (EntityException e) {
            log.error((Object)e.getMessage());
        }
        if (preexistingUser != null) {
            throw new DuplicateEntityException("User [" + username + "] already exists in " + this.getRepository(preexistingUser).getName());
        }
        if (this.leftUserManager.isCreative()) {
            return this.leftUserManager.createUser(username);
        }
        if (this.rightUserManager.isCreative()) {
            return this.rightUserManager.createUser(username);
        }
        throw new UnsupportedOperationException("Tried to create a group in a manager which cannot create entities.");
    }

    public void alterPassword(User user, String plaintextPass) throws EntityException {
        this.getManagerForUser(user).alterPassword(user, plaintextPass);
    }

    public void saveUser(User user) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_saveUser__" + user.getName()));
        }
        log.debug((Object)(" - " + user.getName()));
        this.getManagerForUser(user).saveUser(user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_saveUser__" + user.getName()));
        }
    }

    public void removeUser(User user) throws EntityException, UnsupportedOperationException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_removeUser__" + user.getName()));
        }
        log.debug((Object)(" - " + user.getName()));
        UserManager um = this.getManagerForUser(user);
        um.removeUser(user);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_removeUser__" + user.getName()));
        }
    }

    public boolean isReadOnly(User user) throws EntityException {
        log.debug((Object)(" - " + user.getName()));
        return this.getManagerForUser(user).isReadOnly(user);
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        log.debug((Object)(" - " + user.getName()));
        return this.getManagerForUser(user).getPasswordEncryptor(user);
    }

    public Repository getRepository() {
        return new DelegatingRepository(this.leftUserManager.getRepository(), this.rightUserManager.getRepository());
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Repository homeRepository = null;
        log.debug((Object)(" - " + entity.getName()));
        if (entity instanceof User) {
            UserManager um = this.getManagerForUser((User)entity);
            if (um == null) {
                throw new EntityMissingException("No matching userManager for [" + entity.getName() + "]");
            }
            homeRepository = um.getRepository(entity);
        } else if (entity instanceof ExternalEntity && (homeRepository = this.leftUserManager.getRepository(entity)) == null) {
            homeRepository = this.rightUserManager.getRepository(entity);
        }
        if (homeRepository == null) {
            log.info((Object)("Could not identify a repository for entity: [" + entity + "], " + entity.getClass().getName()));
        }
        return homeRepository;
    }

    public boolean isCreative() {
        return this.leftUserManager.isCreative() || this.rightUserManager.isCreative();
    }

    private UserManager getManagerForUser(User user) throws EntityException {
        if (this.leftUserManager.getUser(user.getName()) != null) {
            return this.leftUserManager;
        }
        if (this.rightUserManager.getUser(user.getName()) != null) {
            return this.rightUserManager;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

