/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ehcache;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.ehcache.EhcacheUserManager;
import com.atlassian.user.impl.ehcache.util.CacheManager;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;

public class EhcacheGroupManager
implements GroupManager {
    public static final String GROUP_CACHE = (class$com$atlassian$user$impl$ehcache$EhcacheGroupManager == null ? (class$com$atlassian$user$impl$ehcache$EhcacheGroupManager = EhcacheGroupManager.class$("com.atlassian.user.impl.ehcache.EhcacheGroupManager")) : class$com$atlassian$user$impl$ehcache$EhcacheGroupManager).getName() + ".groups";
    public static final String HAS_MEMBERSHIP_CACHE = (class$com$atlassian$user$impl$ehcache$EhcacheGroupManager == null ? (class$com$atlassian$user$impl$ehcache$EhcacheGroupManager = EhcacheGroupManager.class$("com.atlassian.user.impl.ehcache.EhcacheGroupManager")) : class$com$atlassian$user$impl$ehcache$EhcacheGroupManager).getName() + ".groups_hasMembership";
    public static final String REPOSITORY_CACHE = EhcacheUserManager.REPOSITORY_CACHE;
    protected final GroupManager underlyingGroupManager;
    protected final CacheManager cacheManager;
    static /* synthetic */ Class class$com$atlassian$user$impl$ehcache$EhcacheGroupManager;

    public EhcacheGroupManager(GroupManager underlyingGroupManager, CacheManager cacheManager) {
        this.underlyingGroupManager = underlyingGroupManager;
        this.cacheManager = cacheManager;
    }

    private Cache getGroupCache() throws EntityException {
        return this.cacheManager.getCache(GROUP_CACHE);
    }

    private Cache getMembershipCheckCache() throws EntityException {
        return this.cacheManager.getCache(HAS_MEMBERSHIP_CACHE);
    }

    private Cache getRepositoryCache() throws EntityException {
        return this.cacheManager.getCache(REPOSITORY_CACHE);
    }

    private Element cacheGroup(Group group) throws EntityException {
        Element cachedGroup = new Element((Serializable)((Object)group.getName()), (Serializable)group);
        this.getGroupCache().put(cachedGroup);
        return cachedGroup;
    }

    private Element cacheMembershipCheck(String entityname, String groupname, boolean val) throws EntityException {
        Element cachedMembershipCheck = new Element((Serializable)((Object)(entityname + "_" + groupname)), (Serializable)new Boolean(val));
        this.getMembershipCheckCache().put(cachedMembershipCheck);
        return cachedMembershipCheck;
    }

    private Element cacheRepository(String username, Repository repository) throws EntityException {
        Element cachedRepositoryElement = new Element((Serializable)((Object)username), (Serializable)repository);
        this.getRepositoryCache().put(cachedRepositoryElement);
        return cachedRepositoryElement;
    }

    public Pager getGroups() throws EntityException {
        return this.underlyingGroupManager.getGroups();
    }

    public Pager getGroups(User user) throws EntityException {
        return this.underlyingGroupManager.getGroups(user);
    }

    public Pager getMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getExternalMemberNames(group);
    }

    public Group getGroup(String groupname) throws EntityException {
        try {
            Element cachedGroup = this.getGroupCache().get((Serializable)((Object)groupname));
            if (cachedGroup != null) {
                return (Group)cachedGroup.getValue();
            }
            Group group = this.underlyingGroupManager.getGroup(groupname);
            if (group != null) {
                this.cacheGroup(group);
            }
            return group;
        }
        catch (CacheException e) {
            throw new EntityException(e);
        }
    }

    public Group createGroup(String groupName) throws EntityException {
        Group createdGroup = this.underlyingGroupManager.createGroup(groupName);
        if (createdGroup != null) {
            this.cacheGroup(createdGroup);
        }
        return createdGroup;
    }

    public void removeGroup(Group group) throws EntityException {
        this.underlyingGroupManager.removeGroup(group);
        this.removeGroupFromCache(group);
    }

    private boolean removeGroupFromCache(Group group) throws EntityException {
        return this.getGroupCache().remove((Serializable)((Object)group.getName()));
    }

    private boolean removeMembershipCheckFromCache(String entityname, String groupname) throws EntityException {
        return this.getMembershipCheckCache().remove((Serializable)((Object)(entityname + "_" + groupname)));
    }

    public void addMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.addMembership(group, user);
        this.cacheMembershipCheck(user.getName(), group.getName(), true);
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        try {
            Element membershipCheckElement = this.getMembershipCheckCache().get((Serializable)((Object)(user.getName() + "_" + group.getName())));
            if (membershipCheckElement != null) {
                Boolean check = (Boolean)membershipCheckElement.getValue();
                return check;
            }
            boolean membership = this.underlyingGroupManager.hasMembership(group, user);
            this.cacheMembershipCheck(user.getName(), group.getName(), membership);
            return membership;
        }
        catch (CacheException e) {
            throw new EntityException(e);
        }
    }

    public void removeMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.removeMembership(group, user);
        this.removeMembershipCheckFromCache(user.getName(), group.getName());
    }

    public boolean supportsExternalMembership() throws EntityException {
        return this.underlyingGroupManager.supportsExternalMembership();
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return this.underlyingGroupManager.isReadOnly(group);
    }

    public Repository getRepository() {
        return this.underlyingGroupManager.getRepository();
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Repository repository = null;
        try {
            Element cachedRepository = this.getRepositoryCache().get((Serializable)((Object)entity.getName()));
            if (cachedRepository == null) {
                repository = this.underlyingGroupManager.getRepository(entity);
                this.cacheRepository(entity.getName(), repository);
                return repository;
            }
            repository = (Repository)cachedRepository.getValue();
            return repository;
        }
        catch (CacheException e) {
            throw new EntityException(e);
        }
    }

    public boolean isCreative() {
        return this.underlyingGroupManager.isCreative();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

