/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPGroup;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class DefaultLDAPGroupFactory
implements LDAPGroupFactory {
    protected final LDAPRepository repository;

    public DefaultLDAPGroupFactory(LDAPRepository repository) {
        this.repository = repository;
    }

    public Group getGroup(Attributes attrs, String distinguishedName) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroup(attrs, " + distinguishedName + ")"));
        }
        Group group = null;
        try {
            Attribute gidAttr = attrs.get(this.repository.getGroupnameAttribute());
            String groupName = null;
            if (gidAttr != null) {
                groupName = (String)gidAttr.get();
                group = new DefaultLDAPGroup(groupName, distinguishedName);
            } else {
                Attribute membershipAttribute = attrs.get(this.repository.getMembershipAttribute());
                group = this.getGroup(membershipAttribute, distinguishedName);
            }
        }
        catch (NamingException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroup(attrs, " + distinguishedName + ")"));
        }
        return group;
    }

    public Group getGroup(String distinguishedName) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroup(" + distinguishedName + ")"));
        }
        String groupName = this.getGroupNameFromDN(distinguishedName);
        DefaultLDAPGroup group = new DefaultLDAPGroup(groupName, distinguishedName);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroup(" + distinguishedName + ")"));
        }
        return group;
    }

    public Group getGroup(Attribute attribute, String distinguishedName) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroup(attr, " + distinguishedName + ")"));
        }
        String groupName = null;
        String groupDN = this.getGroupDNFromMembershipAttribute(attribute);
        groupName = this.getGroupNameFromDN(groupDN);
        DefaultLDAPGroup group = new DefaultLDAPGroup(groupName, groupDN);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroup(attr, " + distinguishedName + ")"));
        }
        return group;
    }

    private String getGroupDNFromMembershipAttribute(Attribute groupMembershipAtt) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_delegating_getGroupDNFromMembershipAttribute"));
        }
        String groupDN = null;
        try {
            NamingEnumeration<?> groupAttrs = groupMembershipAtt.getAll();
            while (groupAttrs.hasMoreElements() && (groupDN = (String)groupAttrs.nextElement()) == null) {
            }
        }
        catch (NamingException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_delegating_getGroupDNFromMembershipAttribute"));
        }
        return groupDN;
    }

    private String getGroupNameFromDN(String groupDN) {
        if (groupDN.indexOf("=") == -1) {
            return groupDN;
        }
        String[] names = groupDN.split(",");
        return names[0].split("=")[1];
    }

    public Entity getEntity(Attributes attrs, String distinguishedName) throws EntityException {
        return this.getGroup(attrs, distinguishedName);
    }

    public Entity getEntity(Attribute attr, String distinguishedName) throws EntityException {
        return this.getGroup(attr, distinguishedName);
    }
}

