/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.ldap.DefaultLDAPUserFactory;
import com.atlassian.user.impl.ldap.LDAPValidator;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.impl.ldap.search.page.LDAPSingleStringPager;
import com.atlassian.user.impl.ldap.search.query.LDAPEntityQueryParser;
import com.atlassian.user.repository.ConfigurationException;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Iterator;

public class LDAPUserManagerReadOnly
implements UserManager {
    private final LDAPRepository repository;
    private final LDAPEntityQueryParser queryParser;
    private LDAPUserAdaptor userAdaptor;

    public LDAPUserManagerReadOnly(LDAPRepository repository, LDAPEntityQueryParser queryParser) throws ConfigurationException {
        this.repository = repository;
        this.queryParser = queryParser;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
    }

    public Pager getUsers() throws EntityException {
        this.profilePush(this.getClass().getName() + "_getUsers");
        LDAPPagerInfo info = this.userAdaptor.search("(" + this.repository.getUsernameAttribute() + "=*)");
        LDAPEntityPager pager = new LDAPEntityPager(this.repository, new DefaultLDAPUserFactory(this.repository), info);
        this.profilePop(this.getClass().getName() + "_getUsers");
        return pager;
    }

    public Pager getUserNames() throws EntityException {
        LDAPPagerInfo info = this.userAdaptor.search("(" + this.repository.getUsernameAttribute() + "=*)", new String[]{this.repository.getUsernameAttribute()});
        return new LDAPSingleStringPager(this.repository, info);
    }

    public User getUser(String username) throws EntityException {
        this.profilePush(this.getClass().getName() + "_getUser(" + username + ")");
        LDAPPagerInfo info = this.userAdaptor.search("(" + this.repository.getUsernameAttribute() + "=" + username + ")");
        User user = null;
        LDAPEntityPager pager = new LDAPEntityPager(this.repository, new DefaultLDAPUserFactory(this.repository), info);
        Iterator iter = pager.iterator();
        while (iter.hasNext() && (user = (User)iter.next()) == null) {
        }
        this.profilePop(this.getClass().getName() + "_getUser(" + username + ")");
        return user;
    }

    public User createUser(String username) throws EntityException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration is read-only");
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        throw new UnsupportedOperationException("This configuration is read-only");
    }

    public void saveUser(User user) throws EntityException {
        throw new UnsupportedOperationException("This configuration is read-only");
    }

    public void removeUser(User user) throws EntityException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This configuration is read-only");
    }

    public boolean isReadOnly(User user) {
        return true;
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        throw new UnsupportedOperationException("This manager does not handle user creation, so does not use a PasswordEncryptor");
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (!LDAPValidator.validateLDAPEntity(entity)) {
            return null;
        }
        if (this.getUser(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public boolean isCreative() {
        return false;
    }

    private void profilePush(String key) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)key);
        }
    }

    private void profilePop(String key) {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)key);
        }
    }
}

