/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerException;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public abstract class AbstractLDAPPager
implements Iterator,
Pager {
    protected static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$search$page$LDAPEntityPager == null ? (class$com$atlassian$user$impl$ldap$search$page$LDAPEntityPager = AbstractLDAPPager.class$("com.atlassian.user.impl.ldap.search.page.LDAPEntityPager")) : class$com$atlassian$user$impl$ldap$search$page$LDAPEntityPager));
    protected NamingEnumeration enume;
    protected String originalQuery;
    protected LDAPRepository repository;
    protected String originalBaseSearchContext;
    protected boolean searchAllDepths;
    protected String[] returningAttributes;
    protected int idx = 0;
    protected List prefetched;
    public boolean lastPage;
    public boolean closed;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$search$page$LDAPEntityPager;

    protected AbstractLDAPPager(LDAPRepository repository, LDAPPagerInfo info) {
        this.repository = repository;
        this.enume = info.getNamingEnumeration();
        this.originalQuery = info.getLDAPQuery();
        this.originalBaseSearchContext = info.getBaseSearchContext();
        this.searchAllDepths = info.isSearchAllDepths();
        this.returningAttributes = info.getReturningAttributes();
    }

    protected abstract List preloadSearchResult(SearchResult var1, List var2) throws EntityException;

    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support removal.");
    }

    public Iterator iterator() {
        return this;
    }

    protected void preload() {
        int currentPos;
        this.prefetched = new ArrayList();
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_preload__(originalQuery= " + this.originalQuery + ")"));
        }
        int limit = this.idx + 100;
        try {
            if (this.closed) {
                SearchControls ctls = new SearchControls();
                ctls.setReturningAttributes(this.returningAttributes);
                this.enume = this.repository.getLDAPContext().search(this.originalBaseSearchContext, this.originalQuery, ctls);
                for (currentPos = 0; currentPos < this.idx; ++currentPos) {
                    this.enume.next();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (currentPos < this.idx) {
            this.idx = currentPos;
            return;
        }
        while (currentPos < limit) {
            try {
                if (!this.enume.hasMore()) {
                    this.lastPage = true;
                    break;
                }
                SearchResult result = (SearchResult)this.enume.nextElement();
                if (result == null) {
                    this.lastPage = true;
                    break;
                }
                this.prefetched = this.preloadSearchResult(result, this.prefetched);
                ++currentPos;
            }
            catch (Exception e) {
                log.error((Object)("At index [" + this.idx + "]: " + e.getMessage()));
                this.lastPage = true;
                break;
            }
        }
        try {
            this.enume.close();
            this.closed = true;
        }
        catch (NamingException e) {
            log.error((Object)"Could not close connection", (Throwable)e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_preload__(originalQuery= " + this.originalQuery + ")"));
        }
    }

    public Object next() {
        if (this.idx % 100 >= this.prefetched.size()) {
            if (!this.lastPage) {
                this.preload();
            } else {
                throw new NoSuchElementException();
            }
        }
        Object nextObj = this.prefetched.get(this.idx % 100);
        ++this.idx;
        return nextObj;
    }

    public boolean isEmpty() {
        return !this.hasNext();
    }

    public List getCurrentPage() {
        return this.prefetched;
    }

    public boolean hasNext() {
        if (this.prefetched.isEmpty() && this.lastPage) {
            return false;
        }
        if (this.idx % 100 == 0 && this.idx != 0 && !this.lastPage) {
            this.preload();
        }
        if (this.lastPage) {
            return this.idx % 100 != this.prefetched.size();
        }
        return true;
    }

    public void nextPage() {
        this.idx += 100;
        this.preload();
    }

    public int getIndex() {
        return this.idx;
    }

    public void skipTo(int idx) throws PagerException {
        this.idx = idx;
        this.preload();
        if (this.prefetched.size() == 0 || this.prefetched == null) {
            this.idx = -1;
        }
    }

    public boolean onLastPage() {
        return this.lastPage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

