/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.page.AbstractLDAPPager;
import com.atlassian.user.impl.ldap.search.page.LDAPSingleStringPager;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

public class LDAPMembershipToUsernamePager
extends LDAPSingleStringPager {
    public LDAPMembershipToUsernamePager(LDAPRepository repository, LDAPPagerInfo info) {
        super(repository, info);
    }

    protected String transform(String value) {
        String[] rdns = value.split(",");
        String[] firstPhrase = rdns[0].split("=");
        return firstPhrase[1];
    }

    protected List preloadSearchResult(SearchResult result, List prefetched) throws EntityException {
        Attributes entityAttributes = result.getAttributes();
        String attributeToFind = this.returningAttributes[0];
        Attribute attr = entityAttributes.get(attributeToFind);
        String val = null;
        if (attr.size() == 1) {
            try {
                val = (String)attr.get();
                prefetched.add(this.transform(val));
            }
            catch (NamingException e) {
                AbstractLDAPPager.log.error((Object)e.getMessage());
            }
        } else {
            try {
                NamingEnumeration<?> interiorList = attr.getAll();
                while (interiorList.hasMoreElements()) {
                    val = (String)interiorList.nextElement();
                    prefetched.add(this.transform(val));
                }
            }
            catch (NamingException e) {
                AbstractLDAPPager.log.error((Object)e.getMessage());
            }
        }
        return prefetched;
    }
}

