/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.GroupQuery;
import com.atlassian.user.search.query.MembershipQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserQuery;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEntityQueryParser
implements EntityQueryParser {
    static /* synthetic */ Class class$com$atlassian$user$search$query$UserQuery;
    static /* synthetic */ Class class$com$atlassian$user$search$query$GroupQuery;
    static /* synthetic */ Class class$com$atlassian$user$search$query$MembershipQuery;

    protected void validateQuery(Query query) throws EntityQueryException {
        if (query instanceof MembershipQuery) {
            throw new IllegalArgumentException("Membership queries are illegal until we verify they can be performed on all LDAP system (i.e. the membership attribute must support substring matching");
        }
        if (query == null) {
            throw new IllegalArgumentException("Null arg.");
        }
        if (!(query instanceof BooleanQuery)) {
            return;
        }
        this.validateBooleanToQueryType((BooleanQuery)query, null);
    }

    protected void validateBooleanToQueryType(BooleanQuery query, String queryClassName) throws EntityQueryException {
        BooleanQuery bQuery = query;
        List queries = bQuery.getQueries();
        Iterator queryIter = queries.iterator();
        while (queryIter.hasNext()) {
            Query foundQuery = (Query)queryIter.next();
            if (foundQuery instanceof BooleanQuery) {
                this.validateBooleanToQueryType((BooleanQuery)foundQuery, queryClassName);
                return;
            }
            if (queryClassName != null) continue;
            queryClassName = this.matchQueryToQueryType(foundQuery);
        }
    }

    protected String matchQueryToQueryType(Query query1) {
        String queryClassName = null;
        if (query1 instanceof UserQuery) {
            queryClassName = (class$com$atlassian$user$search$query$UserQuery == null ? (class$com$atlassian$user$search$query$UserQuery = AbstractEntityQueryParser.class$("com.atlassian.user.search.query.UserQuery")) : class$com$atlassian$user$search$query$UserQuery).getName();
        } else if (query1 instanceof GroupQuery) {
            queryClassName = (class$com$atlassian$user$search$query$GroupQuery == null ? (class$com$atlassian$user$search$query$GroupQuery = AbstractEntityQueryParser.class$("com.atlassian.user.search.query.GroupQuery")) : class$com$atlassian$user$search$query$GroupQuery).getName();
        } else if (query1 instanceof MembershipQuery) {
            queryClassName = (class$com$atlassian$user$search$query$MembershipQuery == null ? (class$com$atlassian$user$search$query$MembershipQuery = AbstractEntityQueryParser.class$("com.atlassian.user.search.query.MembershipQuery")) : class$com$atlassian$user$search$query$MembershipQuery).getName();
        }
        return queryClassName;
    }

    protected Query identifyDefiningQuery(BooleanQuery q) {
        if (q instanceof MembershipQuery) {
            return q;
        }
        Iterator iter = q.getQueries().iterator();
        TermQuery foundQuery = null;
        while (iter.hasNext()) {
            Query query = (Query)iter.next();
            if (query instanceof TermQuery) {
                foundQuery = (TermQuery)query;
                break;
            }
            if (!(query instanceof BooleanQuery)) continue;
            return this.identifyDefiningQuery((BooleanQuery)query);
        }
        return foundQuery;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ SearchResult findGroups(Query var1, QueryContext var2) throws EntityException;

    public abstract /* synthetic */ SearchResult findUsers(Query var1, QueryContext var2) throws EntityException;

    public abstract /* synthetic */ SearchResult findGroups(Query var1) throws EntityException;

    public abstract /* synthetic */ SearchResult findUsers(Query var1) throws EntityException;
}

