/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util.migration;

import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.util.migration.EntityMigrator;
import com.atlassian.user.util.migration.TransferUtils;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.ProfileProvider;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OSUEntityMigrator
implements EntityMigrator {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$util$migration$OSUEntityMigrator == null ? (class$com$atlassian$user$util$migration$OSUEntityMigrator = OSUEntityMigrator.class$("com.atlassian.user.util.migration.OSUEntityMigrator")) : class$com$atlassian$user$util$migration$OSUEntityMigrator));
    public final String USERNAME_COL = "username";
    public final String ID_COL = "id";
    public final String PASSWORD_COL = "passwd";
    public final String KEY_COL = "entity_key";
    public static final String OSUSER_TABLE = "os_user";
    private static final String OSPROPERTYSET_TABLE = "OS_PROPERTYENTRY";
    private UserManager userManager;
    private GroupManager groupManager;
    private PropertySetFactory propertySetFactory;
    private ProfileProvider profileProvider;
    private HashMap migratingUsers;
    private AccessProvider accessProvider;
    public List transitionGroups;
    static /* synthetic */ Class class$com$atlassian$user$util$migration$OSUEntityMigrator;

    public OSUEntityMigrator(UserManager userManager, GroupManager groupManager, PropertySetFactory propertySetFactory, ProfileProvider profileProvider, AccessProvider accessProvider) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.propertySetFactory = propertySetFactory;
        this.profileProvider = profileProvider;
        this.accessProvider = accessProvider;
        this.migratingUsers = new HashMap();
    }

    public void migrateUsers(Connection conn) throws SQLException, EntityException {
        String statement = "select * from os_user";
        Statement st = conn.createStatement();
        st.execute(statement);
        ResultSet rs = st.getResultSet();
        while (rs.next()) {
            String os_username = rs.getString("username");
            String password = rs.getString("passwd");
            long oldid = rs.getLong("id");
            DefaultUser user = new DefaultUser(os_username);
            user.setPassword(password);
            TransitionUser tUser = new TransitionUser(oldid, user);
            this.migratingUsers.put(oldid + "", tUser);
        }
        rs.close();
        this.copyEmailAddresses(conn);
        this.copyFullNames(conn);
        Iterator transIter = this.migratingUsers.keySet().iterator();
        while (transIter.hasNext()) {
            TransitionUser transitionUser = (TransitionUser)this.migratingUsers.get(transIter.next());
            User user = this.userManager.createUser(transitionUser.user.getName());
            TransferUtils.copyUser(transitionUser.user, user);
            this.userManager.alterPassword(user, transitionUser.user.getPassword());
            user.setPassword(transitionUser.user.getPassword());
            this.userManager.saveUser(user);
        }
        conn.close();
    }

    public void migratePropertySetItems() throws EntityException {
        if (this.migratingUsers == null || this.migratingUsers.isEmpty()) {
            log.info((Object)"migratePropertySetItems called but there are no preloaded Users.");
            return;
        }
        Iterator transIter = this.migratingUsers.keySet().iterator();
        while (transIter.hasNext()) {
            TransitionUser user = (TransitionUser)this.migratingUsers.get(transIter.next());
            log.info((Object)("Migrating properties for user " + user.user.getName()));
            PropertySet fromPropertySet = this.profileProvider.getPropertySet(user.user.getName());
            PropertySet toPropertySet = this.propertySetFactory.getPropertySet(this.userManager.getUser(user.user.getName()));
            TransferUtils.copyPropertySet(fromPropertySet, toPropertySet);
            log.info((Object)("Removing email property for property entry on " + user.user.getName()));
            toPropertySet.remove("email");
            log.info((Object)("Removing fullName property for property entry on " + user.user.getName()));
            toPropertySet.remove("fullName");
            log.info((Object)("Complete for " + user.user.getName() + "\n"));
        }
    }

    public void migrateGroups() throws EntityException {
        this.transitionGroups = this.accessProvider.list();
        Iterator transIter = this.transitionGroups.iterator();
        while (transIter.hasNext()) {
            String groupName = (String)transIter.next();
            Group group = null;
            try {
                group = this.groupManager.createGroup(groupName);
            }
            catch (DuplicateEntityException e) {
                // empty catch block
            }
            List oldUsers = this.accessProvider.listUsersInGroup(groupName);
            Iterator membersIter = oldUsers.iterator();
            while (membersIter.hasNext()) {
                String memberName = (String)membersIter.next();
                this.groupManager.addMembership(group, this.userManager.getUser(memberName));
            }
        }
    }

    private void copyFullNames(Connection conn) throws SQLException {
        Iterator usersInTransition = this.migratingUsers.keySet().iterator();
        while (usersInTransition.hasNext()) {
            TransitionUser trans = (TransitionUser)this.migratingUsers.get(usersInTransition.next());
            String statement2 = "select * from OS_PROPERTYENTRY where entity_id = " + trans.oldid + " and entity_name='OSUser_user' and entity_key='fullName'";
            Statement st2 = conn.createStatement();
            st2.execute(statement2);
            ResultSet rs2 = st2.getResultSet();
            rs2.next();
            String os_fullName = rs2.getString("string_val");
            trans.user.setFullName(os_fullName);
            log.info((Object)("Have set [" + trans.user.getName() + "] fullname to " + os_fullName));
            rs2.close();
        }
    }

    private void copyEmailAddresses(Connection conn) throws SQLException {
        Iterator usersInTransition = this.migratingUsers.keySet().iterator();
        while (usersInTransition.hasNext()) {
            TransitionUser trans = (TransitionUser)this.migratingUsers.get(usersInTransition.next());
            String statement2 = "select * from OS_PROPERTYENTRY where entity_id = " + trans.oldid + " and entity_name='OSUser_user' and entity_key='email'";
            Statement st2 = conn.createStatement();
            st2.execute(statement2);
            ResultSet rs2 = st2.getResultSet();
            rs2.next();
            String os_email = rs2.getString("string_val");
            trans.user.setEmail(os_email);
            log.info((Object)("Have set [" + trans.user.getName() + "] email to " + os_email));
            rs2.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TransitionUser {
        protected DefaultUser user;
        protected long oldid;

        public TransitionUser(long oldid, DefaultUser user) {
            this.user = user;
            this.oldid = oldid;
        }
    }
}

