/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.util.Asserts;
import java.io.File;

public final class Agent {
    public static final long CAPABILITY_CAN_RECORD_METHOD_INVOCATION_COUNTS = 64L;
    public static final long CAPABILITY_CAN_CAPTURE_ON_USED_MEMORY_THRESHOLD = 128L;
    public static final long CAPABILITY_CAN_RECORD_ALLOCATIONS = 256L;
    public static final long CAPABILITY_JVM_BASIC_TELEMETRY = 512L;
    public static final long CAPABILITY_CLR_BASIC_TELEMETRY = 1024L;
    public static final long STATUS_ALLOCATIONS_RECORDED = 2L;
    public static final long STATUS_CPU_TIMES = 4L;
    public static final long STATUS_CPU_COUNTS = 8L;
    public static final long STATUS_CPU_NOLIB = 16L;
    public static final long STATUS_CPU_PROFILING = 28L;

    public static String getMethodCountingNotSupportedMessage(long actualCapabilities, String javaVersion, boolean isJVMTI) {
        Asserts.notNull(javaVersion);
        if ((actualCapabilities & 0x40L) != 0L) {
            return null;
        }
        if (isJVMTI) {
            return "Method invocation count recording was explicitly disabled for this application on its startup.";
        }
        if (javaVersion.startsWith("1.5")) {
            return "Method invocation count recording is not supported via deprecated JVMPI profiling API.\nSpecify -agentlib:yjpagent option instead of -Xrunyjpagent to use the modern JVMTI API.";
        }
        return "Method invocation count recording is not supported in Java " + javaVersion + ".\n" + "It requires Java 5.0 or higher.";
    }

    public static String getTelemetryNotSupportedMessage(long actualCapabilities, String javaVersion) {
        Asserts.notNull(javaVersion);
        if ((actualCapabilities & 0x200L) != 0L || (actualCapabilities & 0x400L) != 0L) {
            return null;
        }
        if (javaVersion.startsWith("1.5")) {
            return "Telemetry is not supported via deprecated JVMPI profiling API.\nSpecify -agentlib:yjpagent option instead of -Xrunyjpagent to use the modern JVMTI API.";
        }
        return "Telemetry is not supported in Java " + javaVersion + ".\n" + "It requires Java 5.0 or higher.";
    }

    static String getAllocationRecordingNotSupportedMessage(long actualCapabilities) {
        if ((actualCapabilities & 0x100L) != 0L) {
            return null;
        }
        return "Object allocation recording was explicitly disabled for this application on its startup.";
    }

    public static String getCaptureOnLowMemoryNotSupportedMessage() {
        return "Snapshot capture on used memory threshold is not supported in Java 1.3, it requires Java 1.4 or higher";
    }

    public static File suggestSnapshotFile(File directory, String fileNamePrefix, String fileExtension) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        Asserts.notNull(fileNamePrefix);
        Asserts.notNull(fileExtension);
        File[] files = directory.listFiles();
        if (files == null) {
            int index = 0;
            while (true) {
                String fileName;
                File result;
                if (!(result = new File(directory, fileName = fileNamePrefix + (index == 0 ? "" : "(" + index + ")") + fileExtension)).exists()) {
                    return result;
                }
                ++index;
            }
        }
        int maxFound = -1;
        String start = fileNamePrefix + "(";
        String nameWithoutNumber = fileNamePrefix + fileExtension;
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (name.equals(nameWithoutNumber)) {
                maxFound = Math.max(maxFound, 0);
                continue;
            }
            String end = ")" + fileExtension;
            if (!name.startsWith(start) || !name.endsWith(end)) continue;
            String numberStr = name.substring(start.length(), name.length() - end.length());
            try {
                int value = Integer.parseInt(numberStr);
                maxFound = Math.max(value, maxFound);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String fileName = fileNamePrefix + (++maxFound == 0 ? "" : "(" + maxFound + ")") + fileExtension;
        return new File(directory, fileName);
    }

    public static String sessionNameToFileNamePart(String sessionName) {
        StringBuffer result = new StringBuffer(sessionName.length());
        for (int i = 0; i < sessionName.length(); ++i) {
            char ch = sessionName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '.') {
                result.append(ch);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }
}

