/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.emitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import net.sf.joost.emitter.StreamEmitter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HtmlEmitter
extends StreamEmitter {
    private boolean propOmitXmlDeclaration = false;
    private boolean insideCDATA = false;
    private static final HashSet emptyHTMLElements = new HashSet();

    public HtmlEmitter(Writer writer, String string) {
        super(writer, string);
    }

    public void setOmitXmlDeclaration(boolean bl) {
        this.propOmitXmlDeclaration = bl;
    }

    public void startDocument() throws SAXException {
        if (this.propOmitXmlDeclaration) {
            return;
        }
        try {
            this.writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(string3);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ').append(attributes.getQName(i)).append("=\"");
            char[] cArray = attributes.getValue(i).toCharArray();
            block13: for (int j = 0; j < cArray.length; ++j) {
                switch (cArray[j]) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block13;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block13;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block13;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block13;
                    }
                    case '\t': {
                        stringBuffer.append("&#x9;");
                        continue block13;
                    }
                    case '\n': {
                        stringBuffer.append("&#xA;");
                        continue block13;
                    }
                    case '\r': {
                        stringBuffer.append("&#xD;");
                        continue block13;
                    }
                    case '\u00a0': {
                        stringBuffer.append("&nbsp;");
                        continue block13;
                    }
                    default: {
                        j = this.encodeCharacters(cArray, j, stringBuffer);
                    }
                }
            }
            stringBuffer.append('\"');
        }
        stringBuffer.append(">");
        try {
            this.writer.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!emptyHTMLElements.contains(string3.toUpperCase())) {
            try {
                this.writer.write("</");
                this.writer.write(string3);
                this.writer.write(">");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.insideCDATA) {
                for (int i = 0; i < n2; ++i) {
                    if (this.charsetEncoder.canEncode(cArray[n + i])) continue;
                    throw new SAXException("Cannot output character with code " + cArray[n + i] + " in the encoding `" + this.encoding + "'");
                }
                this.writer.write(cArray, n, n2);
            } else {
                StringBuffer stringBuffer = new StringBuffer((int)((float)n2 * 1.3f));
                block9: for (int i = 0; i < n2; ++i) {
                    switch (cArray[n + i]) {
                        case '&': {
                            stringBuffer.append("&amp;");
                            continue block9;
                        }
                        case '<': {
                            stringBuffer.append("&lt;");
                            continue block9;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            continue block9;
                        }
                        case '\u00a0': {
                            stringBuffer.append("&nbsp;");
                            continue block9;
                        }
                        default: {
                            i = this.encodeCharacters(cArray, n + i, stringBuffer) - n;
                        }
                    }
                }
                this.writer.write(stringBuffer.toString());
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writer.write("<!--");
            this.writer.write(cArray, n, n2);
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startCDATA() throws SAXException {
        this.insideCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
    }

    static {
        emptyHTMLElements.add("AREA");
        emptyHTMLElements.add("BASE");
        emptyHTMLElements.add("BASEFONT");
        emptyHTMLElements.add("BR");
        emptyHTMLElements.add("COL");
        emptyHTMLElements.add("FRAME");
        emptyHTMLElements.add("HR");
        emptyHTMLElements.add("IMG");
        emptyHTMLElements.add("INPUT");
        emptyHTMLElements.add("ISINDEX");
        emptyHTMLElements.add("LINK");
        emptyHTMLElements.add("META");
        emptyHTMLElements.add("PARAM");
    }
}

