/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.grammar;

import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Value;
import org.xml.sax.SAXException;

public abstract class Tree {
    public static final int ROOT = 1;
    public static final int CHILD = 2;
    public static final int DESC = 3;
    public static final int UNION = 4;
    public static final int NAME_TEST = 5;
    public static final int WILDCARD = 6;
    public static final int URI_WILDCARD = 7;
    public static final int LOCAL_WILDCARD = 8;
    public static final int NODE_TEST = 9;
    public static final int TEXT_TEST = 10;
    public static final int CDATA_TEST = 100;
    public static final int COMMENT_TEST = 11;
    public static final int PI_TEST = 12;
    public static final int FUNCTION = 13;
    public static final int PREDICATE = 14;
    public static final int NUMBER = 15;
    public static final int STRING = 16;
    public static final int ADD = 17;
    public static final int SUB = 18;
    public static final int MULT = 19;
    public static final int DIV = 20;
    public static final int MOD = 21;
    public static final int AND = 22;
    public static final int OR = 23;
    public static final int EQ = 24;
    public static final int NE = 25;
    public static final int LT = 26;
    public static final int LE = 27;
    public static final int GT = 28;
    public static final int GE = 29;
    public static final int ATTR = 30;
    public static final int ATTR_WILDCARD = 31;
    public static final int ATTR_URI_WILDCARD = 32;
    public static final int ATTR_LOCAL_WILDCARD = 33;
    public static final int LIST = 34;
    public static final int SEQ = 35;
    public static final int AVT = 36;
    public static final int VAR = 37;
    public static final int DOT = 38;
    public static final int DDOT = 39;
    public static final int VALUE = 40;
    public int type;
    public Tree left;
    public Tree right;
    public Object value;
    public String uri;
    public String lName;

    private Tree(int n, Tree tree, Tree tree2, Object object) {
        this.type = n;
        this.left = tree;
        this.right = tree2;
        this.value = object;
    }

    public Tree(int n, Tree tree, Tree tree2) {
        this(n, tree, tree2, null);
    }

    public Tree(int n, Object object) {
        this(n, null, null, object);
    }

    public Tree(int n) {
        this(n, null, null, null);
    }

    public boolean matches(Context context, int n, boolean bl) throws SAXException {
        context.errorHandler.fatalError("Fatal: unprocessed type in matching: " + this, context.currentInstruction.publicId, context.currentInstruction.systemId, context.currentInstruction.lineNo, context.currentInstruction.colNo);
        return false;
    }

    public Value evaluate(Context context, NodeBase nodeBase) throws SAXException {
        context.currentInstruction = nodeBase;
        return this.evaluate(context, context.ancestorStack.size());
    }

    public Value evaluate(Context context, int n) throws SAXException {
        context.errorHandler.fatalError("Fatal: unprocessed type in evaluating: " + this, context.currentInstruction.publicId, context.currentInstruction.systemId, context.currentInstruction.lineNo, context.currentInstruction.colNo);
        return null;
    }

    public Tree reverseAssociativity() {
        return this;
    }

    public double getPriority() {
        return 0.5;
    }

    public String toString() {
        String string = "{";
        switch (this.type) {
            case 1: {
                string = string + "ROOT";
                break;
            }
            case 2: {
                string = string + "CHILD";
                break;
            }
            case 3: {
                string = string + "DESC";
                break;
            }
            case 5: {
                string = string + "NAME_TEST";
                break;
            }
            case 10: {
                string = string + "TEXT_TEST";
                break;
            }
            case 9: {
                string = string + "NODE_TEST";
                break;
            }
            case 11: {
                string = string + "COMMENT_TEST";
                break;
            }
            case 30: {
                string = string + "ATTR";
                break;
            }
            case 24: {
                string = string + "EQ";
                break;
            }
            case 16: {
                string = string + "STRING";
                break;
            }
            case 15: {
                string = string + "NUMBER";
                break;
            }
            case 6: {
                string = string + "*";
                break;
            }
            case 39: {
                string = string + "..";
                break;
            }
            default: {
                string = string + this.type;
            }
        }
        string = string + "," + this.left + "," + this.right + "," + this.value;
        if (this.type == 5 || this.type == 7 || this.type == 8) {
            string = string + "(" + this.uri + "|" + this.lName + ")";
        }
        return string + "}";
    }
}

