/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Emitter;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class CdataFactory
extends FactoryBase {
    public String getName() {
        return "cdata";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        CdataFactory.checkAttributes(string, attributes, null, parseContext);
        return new Instance(string, nodeBase, parseContext);
    }

    public class Instance
    extends NodeBase {
        private StringEmitter strEmitter;
        private StringBuffer buffer = new StringBuffer();

        public Instance(String string, NodeBase nodeBase, ParseContext parseContext) {
            super(string, nodeBase, parseContext, true);
            this.strEmitter = new StringEmitter(this.buffer, "(`" + string + "' started in line " + this.lineNo + ")");
        }

        public short process(Context context) throws SAXException {
            if (context.emitter.isEmitterActive(this.strEmitter)) {
                context.errorHandler.error("Can't create nested CDATA section here", this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            super.process(context);
            this.buffer.setLength(0);
            context.pushEmitter(this.strEmitter);
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            context.popEmitter();
            Emitter emitter = context.emitter;
            emitter.startCDATA(this);
            emitter.characters(this.buffer.toString().toCharArray(), 0, this.buffer.length(), this);
            emitter.endCDATA();
            return super.processEnd(context);
        }
    }
}

