/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.instruction.TemplateBase;
import net.sf.joost.instruction.VariableBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import net.sf.joost.stx.Value;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ParamFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public ParamFactory() {
        this.attrNames.add("name");
        this.attrNames.add("required");
        this.attrNames.add("select");
    }

    public String getName() {
        return "param";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        if (nodeBase == null || !(nodeBase instanceof GroupBase) && !(nodeBase instanceof TemplateBase)) {
            throw new SAXParseException("`" + string + "' must be a top level element " + "or a child of stx:group, stx:template, or stx:procedure", parseContext.locator);
        }
        String string2 = ParamFactory.getAttribute(string, attributes, "name", parseContext);
        String string3 = ParamFactory.getExpandedName(string2, parseContext);
        boolean bl = ParamFactory.getEnumAttValue("required", attributes, YESNO_VALUES, parseContext) == 0;
        Tree tree = ParamFactory.parseExpr(attributes.getValue("select"), parseContext);
        if (bl && tree != null) {
            throw new SAXParseException("`" + string + "' must not have a `select' attribute if it " + "declares the parameter as required", parseContext.locator);
        }
        ParamFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, string2, string3, tree, bl);
    }

    public class Instance
    extends VariableBase {
        private String varName;
        private Tree select;
        private boolean required;
        private AbstractInstruction contents;
        private AbstractInstruction successor;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, String string2, String string3, Tree tree, boolean bl) {
            super(string, nodeBase, parseContext, string3, false, tree == null && !bl);
            this.varName = string2;
            this.select = tree;
            this.required = bl;
        }

        public boolean compile(int n, ParseContext parseContext) {
            if (n == 0) {
                return true;
            }
            this.contents = this.next;
            this.successor = this.nodeEnd != null ? this.nodeEnd.next : this.next;
            return false;
        }

        public short process(Context context) throws SAXException {
            Value value = this.parent instanceof GroupBase ? (Value)context.globalParameters.get(this.expName) : (Value)context.passedParameters.get(this.expName);
            if (value == null) {
                if (this.required) {
                    context.errorHandler.error("Missing value for required parameter `" + this.varName + "'", this.publicId, this.systemId, this.lineNo, this.colNo);
                    return 0;
                }
                if (this.select != null) {
                    value = this.select.evaluate(context, this);
                } else {
                    this.next = this.contents;
                    super.process(context);
                    context.pushEmitter(new StringEmitter(new StringBuffer(), "(`" + this.qName + "' started in line " + this.lineNo + ")"));
                    return 0;
                }
            }
            this.processParam(value, context);
            if (this.nodeEnd != null) {
                this.next = this.successor;
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            this.processParam(new Value(((StringEmitter)context.popEmitter()).getBuffer().toString()), context);
            return super.processEnd(context);
        }

        public void processParam(Value value, Context context) throws SAXException {
            Hashtable hashtable = this.parent instanceof GroupBase ? (Hashtable)((Stack)context.groupVars.get(this.parent)).peek() : context.localVars;
            if (hashtable.get(this.expName) != null) {
                context.errorHandler.error("Param `" + this.varName + "' already declared", this.publicId, this.systemId, this.lineNo, this.colNo);
                return;
            }
            hashtable.put(this.expName, value);
            if (hashtable == context.localVars) {
                this.parent.declareVariable(this.expName);
            }
        }
    }
}

