/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import net.sf.joost.Constants;
import net.sf.joost.emitter.BufferEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.GroupBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Emitter;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ResultBufferFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();

    public ResultBufferFactory() {
        this.attrNames.add("name");
        this.attrNames.add("clear");
    }

    public String getName() {
        return "result-buffer";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2 = ResultBufferFactory.getAttribute(string, attributes, "name", parseContext);
        String string3 = "@" + ResultBufferFactory.getExpandedName(string2, parseContext);
        boolean bl = ResultBufferFactory.getEnumAttValue("clear", attributes, YESNO_VALUES, parseContext) == 0;
        ResultBufferFactory.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, string2, string3, bl);
    }

    public final class Instance
    extends NodeBase {
        private String bufName;
        private String expName;
        private boolean clear;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, String string2, String string3, boolean bl) {
            super(string, nodeBase, parseContext, true);
            this.bufName = string2;
            this.expName = string3;
            this.clear = bl;
        }

        public short process(Context context) throws SAXException {
            Constants constants;
            super.process(context);
            Object v = context.localVars.get(this.expName);
            if (v == null) {
                constants = context.currentGroup;
                while (v == null && constants != null) {
                    v = ((Hashtable)((Stack)context.groupVars.get(constants)).peek()).get(this.expName);
                    constants = ((GroupBase)constants).parentGroup;
                }
            }
            if (v == null) {
                context.errorHandler.error("Can't fill an undeclared buffer `" + this.bufName + "'", this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            constants = (BufferEmitter)((Emitter)v).contH;
            if (context.emitter.isEmitterActive((StxEmitter)constants)) {
                context.errorHandler.error("Buffer `" + this.bufName + "' acts already as result buffer", this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            if (this.clear) {
                ((BufferEmitter)constants).clear();
            }
            context.pushEmitter((Emitter)v);
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            ((BufferEmitter)context.popEmitter()).filled();
            return super.processEnd(context);
        }
    }
}

