/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Stack;
import net.sf.joost.Constants;
import net.sf.joost.emitter.BufferEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.ErrorHandlerImpl;
import net.sf.joost.stx.helpers.MutableAttributes;
import net.sf.joost.stx.helpers.MutableAttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Emitter
implements Constants {
    public ContentHandler contH;
    private LexicalHandler lexH;
    private ErrorHandlerImpl errorHandler;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private Stack nsStack = new Stack();
    private String nsDefault = "";
    private Stack openedElements = new Stack();
    public Emitter prev;
    private String lastUri;
    private String lastLName;
    private String lastQName;
    private MutableAttributes lastAttrs;
    private NodeBase lastInstruction;
    private boolean insideCDATA = false;

    public Emitter(ErrorHandlerImpl errorHandlerImpl) {
        this.errorHandler = errorHandlerImpl;
    }

    protected Emitter(Emitter emitter, StxEmitter stxEmitter) {
        this(emitter.errorHandler);
        this.prev = emitter;
        this.contH = stxEmitter;
        this.lexH = stxEmitter;
    }

    public Emitter pushEmitter(StxEmitter stxEmitter) {
        if (stxEmitter.getSystemId() == null && this.contH instanceof StxEmitter) {
            stxEmitter.setSystemId(((StxEmitter)this.contH).getSystemId());
        }
        return new Emitter(this, stxEmitter);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contH = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexH = lexicalHandler;
    }

    private void processLastElement() throws SAXException {
        try {
            this.contH.startElement(this.lastUri, this.lastLName, this.lastQName, this.lastAttrs);
        }
        catch (SAXException sAXException) {
            this.errorHandler.error(sAXException.getMessage(), this.lastInstruction.publicId, this.lastInstruction.systemId, this.lastInstruction.lineNo, this.lastInstruction.colNo);
        }
        this.openedElements.push(this.lastUri);
        this.openedElements.push(this.lastQName);
        this.lastAttrs = null;
    }

    public void addAttribute(String string, String string2, String string3, String string4, NodeBase nodeBase) throws SAXException {
        if (this.lastAttrs == null) {
            this.errorHandler.error("Can't create an attribute if there's no opened element", nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            return;
        }
        if (this.contH != null) {
            String string5;
            int n = this.lastAttrs.getIndex(string, string3);
            if (n != -1) {
                this.lastAttrs.setValue(n, string4);
            } else {
                this.lastAttrs.addAttribute(string, string3, string2, "CDATA", string4);
            }
            int n2 = string2.indexOf(":");
            if (n2 != -1 && !string.equals(this.nsSupport.getURI(string5 = string2.substring(0, n2)))) {
                this.nsSupport.declarePrefix(string5, string);
                this.nsStack.push(string5);
                this.contH.startPrefixMapping(string5, string);
            }
        }
    }

    public void startDocument() throws SAXException {
        if (this.contH != null) {
            this.contH.startDocument();
        }
    }

    public void endDocument(AbstractInstruction abstractInstruction) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (!this.openedElements.isEmpty()) {
                this.errorHandler.fatalError("Missing end tag for `" + this.openedElements.pop() + "' at the end of the " + (this.contH instanceof BufferEmitter ? "buffer" : "document"), abstractInstruction.getNode().publicId, abstractInstruction.getNode().systemId, abstractInstruction.lineNo, abstractInstruction.colNo);
            }
            this.contH.endDocument();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable, NodeBase nodeBase) throws SAXException {
        if (this.contH != null) {
            Object object;
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            this.nsSupport.pushContext();
            this.nsStack.push(null);
            int n = string3.indexOf(":");
            if (n != -1) {
                object = string3.substring(0, n);
                if (!string.equals(this.nsSupport.getURI((String)object))) {
                    this.nsSupport.declarePrefix((String)object, string);
                    this.nsStack.push(object);
                    this.contH.startPrefixMapping((String)object, string);
                }
            } else if (!string.equals(this.nsDefault)) {
                this.nsSupport.declarePrefix("", string);
                this.nsDefault = string;
                this.nsStack.push("");
                this.contH.startPrefixMapping("", string);
            }
            this.lastUri = string;
            this.lastLName = string2;
            this.lastQName = string3;
            this.lastAttrs = new MutableAttributesImpl(attributes);
            if (hashtable != null) {
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string4 = (String)object.nextElement();
                    String string5 = (String)hashtable.get(string4);
                    if ("".equals(string4)) {
                        if (string5.equals(this.nsDefault)) continue;
                        this.contH.startPrefixMapping("", string5);
                        this.nsSupport.declarePrefix("", string5);
                        this.nsDefault = string5;
                        this.nsStack.push("");
                        continue;
                    }
                    if (string5.equals(this.nsSupport.getURI(string4))) continue;
                    this.contH.startPrefixMapping(string4, string5);
                    this.nsSupport.declarePrefix(string4, string5);
                    this.nsStack.push(string4);
                }
            }
            this.lastInstruction = nodeBase;
        }
    }

    public void endElement(String string, String string2, String string3, AbstractInstruction abstractInstruction) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (this.openedElements.isEmpty()) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag " + (string3 != null ? "`" + string3 + "' " : "") + "(no element opened)", abstractInstruction.getNode().publicId, abstractInstruction.getNode().systemId, abstractInstruction.lineNo, abstractInstruction.colNo);
                return;
            }
            String string4 = (String)this.openedElements.pop();
            String string5 = (String)this.openedElements.pop();
            if (!string3.equals(string4)) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag `" + string3 + "' (`" + string4 + "' expected)", abstractInstruction.getNode().publicId, abstractInstruction.getNode().systemId, abstractInstruction.lineNo, abstractInstruction.colNo);
                return;
            }
            if (!string.equals(string5)) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag `{" + string + "}" + string3 + "' (`{" + string5 + "}" + string4 + "' expected)", abstractInstruction.getNode().publicId, abstractInstruction.getNode().systemId, abstractInstruction.lineNo, abstractInstruction.colNo);
                return;
            }
            this.contH.endElement(string, string2, string3);
            this.nsSupport.popContext();
            String string6 = (String)this.nsStack.pop();
            while (string6 != null) {
                this.contH.endPrefixMapping(string6);
                if (string6 == "") {
                    this.nsDefault = this.nsSupport.getURI("");
                    if (this.nsDefault == null) {
                        this.nsDefault = "";
                    }
                }
                string6 = (String)this.nsStack.pop();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2, NodeBase nodeBase) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            try {
                if (this.insideCDATA) {
                    String string = new String(cArray, n, n2);
                    int n3 = string.indexOf("]]>");
                    while (n3 != -1) {
                        this.contH.characters(string.substring(0, n3 += 2).toCharArray(), 0, n3);
                        this.lexH.endCDATA();
                        this.lexH.startCDATA();
                        string = string.substring(n3);
                        n3 = string.indexOf("]]>");
                    }
                    this.contH.characters(string.toCharArray(), 0, string.length());
                } else {
                    this.contH.characters(cArray, n, n2);
                }
            }
            catch (SAXException sAXException) {
                this.errorHandler.fatalError(sAXException.getMessage(), nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
        }
    }

    public void processingInstruction(String string, String string2, NodeBase nodeBase) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            try {
                this.contH.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
        }
    }

    public void comment(char[] cArray, int n, int n2, NodeBase nodeBase) throws SAXException {
        if (this.contH != null && this.lastAttrs != null) {
            this.processLastElement();
        }
        if (this.lexH != null) {
            try {
                this.lexH.comment(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
        }
    }

    public void startCDATA(NodeBase nodeBase) throws SAXException {
        if (this.contH != null && this.lastAttrs != null) {
            this.processLastElement();
        }
        if (this.lexH != null) {
            try {
                this.lexH.startCDATA();
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
            }
            this.insideCDATA = true;
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexH != null) {
            this.lexH.endCDATA();
            this.insideCDATA = false;
        }
    }

    public boolean isEmitterActive(StxEmitter stxEmitter) {
        if (this.contH == stxEmitter) {
            return true;
        }
        if (this.prev != null) {
            return this.prev.isEmitterActive(stxEmitter);
        }
        return false;
    }

    public Writer getResultWriter(String string, String string2, String string3, String string4, int n, int n2, boolean bl) throws IOException, SAXException, URISyntaxException {
        OutputStreamWriter outputStreamWriter;
        int n3;
        String string5;
        File file = null;
        if (this.contH instanceof StxEmitter && (string5 = ((StxEmitter)this.contH).getSystemId()) != null) {
            file = new File(new URI(string5).resolve(string));
        }
        if (file == null) {
            file = string.indexOf(58) != -1 ? new File(new URI(string)) : new File(string);
        }
        if ((n3 = (string5 = file.getAbsolutePath()).lastIndexOf(File.separator)) != -1) {
            new File(string5.substring(0, n3)).mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string6 = "Unsupported encoding `" + string2 + "', using " + "UTF-8";
            this.errorHandler.warning(string6, string3, string4, n, n2);
            string2 = "UTF-8";
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        }
        return outputStreamWriter;
    }
}

