/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.stx.SAXEvent;

public class Value
implements Cloneable {
    private static NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    public static final Value VAL_TRUE;
    public static final Value VAL_FALSE;
    public static final Value VAL_EMPTY;
    public static final Value VAL_EMPTY_STRING;
    public static final Value VAL_ZERO;
    public static final Value VAL_NAN;
    public static final int EMPTY = 0;
    public static final int NODE = 1;
    public static final int BOOLEAN = 2;
    public static final int NUMBER = 3;
    public static final int STRING = 4;
    public static final int OBJECT = 5;
    public int type;
    private SAXEvent event;
    private boolean bool;
    private double number;
    private String string;
    private Object object;
    public Value next;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    private Value() {
        this.type = 0;
    }

    public Value(double d) {
        this.type = 3;
        this.number = d;
    }

    public static Value getBoolean(boolean bl) {
        return bl ? VAL_TRUE : VAL_FALSE;
    }

    private Value(boolean bl) {
        this.type = 2;
        this.bool = bl;
    }

    public Value(String string) {
        this.type = 4;
        this.string = string;
    }

    public Value(SAXEvent sAXEvent) {
        this.type = 1;
        this.event = sAXEvent;
    }

    public Value(Object object) {
        if (object == null) {
            this.type = 5;
            return;
        }
        if (object instanceof Void) {
            this.type = 0;
            return;
        }
        if (object instanceof String || object instanceof Character) {
            this.type = 4;
            this.string = object.toString();
            return;
        }
        if (object instanceof Boolean) {
            this.type = 2;
            this.bool = (Boolean)object;
            return;
        }
        if (object instanceof Number) {
            this.type = 3;
            this.number = ((Number)object).doubleValue();
            return;
        }
        this.type = 5;
        this.object = object;
    }

    public String getString() {
        return this.string;
    }

    public SAXEvent getNode() {
        return this.event;
    }

    public Object getObject() {
        return this.object;
    }

    public double getNumberValue() {
        switch (this.type) {
            case 3: {
                return this.number;
            }
            case 0: {
                return Double.NaN;
            }
            case 2: {
                return this.bool ? 1.0 : 0.0;
            }
            case 1: 
            case 5: {
                try {
                    return Double.parseDouble(this.getStringValue());
                }
                catch (NumberFormatException numberFormatException) {
                    return Double.NaN;
                }
            }
            case 4: {
                try {
                    return Double.parseDouble(this.string);
                }
                catch (NumberFormatException numberFormatException) {
                    return Double.NaN;
                }
            }
        }
        throw new RuntimeException("Don't know how to convert " + this.type + " to number");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringValue() {
        switch (this.type) {
            case 4: {
                return this.string;
            }
            case 1: {
                return this.event.value;
            }
            case 0: {
                return "";
            }
            case 2: {
                return this.bool ? "true" : "false";
            }
            case 3: {
                if ((this.number < 0.001 || this.number >= 1.0E7) && !Double.isInfinite(this.number)) {
                    NumberFormat numberFormat = Value.numberFormat;
                    synchronized (numberFormat) {
                        return Value.numberFormat.format(this.number);
                    }
                }
                String string = Double.toString(this.number);
                if (string.endsWith(".0")) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
            case 5: {
                return this.object != null ? this.object.toString() : "";
            }
        }
        throw new RuntimeException("Don't know how to convert " + this.type + " to string");
    }

    public boolean getBooleanValue() {
        switch (this.type) {
            case 2: {
                return this.bool;
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
            case 3: {
                return this.number != 0.0;
            }
            case 4: {
                return !this.string.equals("");
            }
            case 5: {
                return this.object == null ? false : !this.object.toString().equals("");
            }
        }
        throw new RuntimeException("Don't know how to convert " + this.type + " to boolean");
    }

    public Value copy() {
        Value value = new Value();
        value.bool = this.bool;
        value.event = this.event;
        value.number = this.number;
        value.object = this.object;
        value.string = this.string;
        value.type = this.type;
        if (this.next != null) {
            value.next = this.next.copy();
        }
        return value;
    }

    public Value singleCopy() {
        switch (this.type) {
            case 2: {
                return Value.getBoolean(this.bool);
            }
            case 1: {
                return new Value(this.event);
            }
            case 3: {
                return new Value(this.number);
            }
            case 4: {
                return new Value(this.string);
            }
            case 5: {
                return new Value(this.object);
            }
        }
        return VAL_EMPTY;
    }

    public static Value concat(Value value, Value value2) {
        try {
            if (value.next == null) {
                Value value3 = (Value)value.clone();
                value3.next = value2;
                return value3;
            }
            Value value4 = value;
            while (value4.next.next != null) {
                value4 = value4.next;
            }
            value4.next = (Value)value4.next.clone();
            value4.next.next = value2;
            return value;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public double getDistanceTo(Class clazz) {
        if (this.type == 5) {
            if (this.object == null || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Value.class$("java.lang.Object")) : class$java$lang$Object)) {
                return 2.0;
            }
            if (clazz == this.object.getClass()) {
                return 0.0;
            }
            if (clazz.isAssignableFrom(this.object.getClass())) {
                return 1.0;
            }
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                return 100.0;
            }
        }
        if (clazz == (class$java$util$List == null ? (class$java$util$List = Value.class$("java.util.List")) : class$java$util$List)) {
            return 90.0;
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Value.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 100.0;
        }
        switch (this.type) {
            case 0: {
                if (clazz.isPrimitive()) break;
                return 1.0;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    return 0.0;
                }
                if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return 1.0;
                }
                if (clazz == Byte.TYPE) {
                    return 10.0;
                }
                if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return 11.0;
                }
                if (clazz == Short.TYPE) {
                    return 12.0;
                }
                if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return 13.0;
                }
                if (clazz == Integer.TYPE) {
                    return 14.0;
                }
                if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return 15.0;
                }
                if (clazz == Long.TYPE) {
                    return 16.0;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return 17.0;
                }
                if (clazz == Character.TYPE) {
                    return 18.0;
                }
                if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return 19.0;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                    return 20.0;
                }
                if (clazz == Float.TYPE) {
                    return 21.0;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 22.0;
                }
                if (clazz == Double.TYPE) {
                    return 23.0;
                }
                if (clazz != (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) break;
                return 24.0;
            }
            case 3: {
                if (clazz == Double.TYPE) {
                    return 0.0;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 1.0;
                }
                if (clazz == Float.TYPE) {
                    return 2.0;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 3.0;
                }
                if (clazz == Long.TYPE) {
                    return 4.0;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return 5.0;
                }
                if (clazz == Integer.TYPE) {
                    return 6.0;
                }
                if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return 7.0;
                }
                if (clazz == Short.TYPE) {
                    return 8.0;
                }
                if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return 9.0;
                }
                if (clazz == Byte.TYPE) {
                    return 10.0;
                }
                if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return 11.0;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                    return 20.0;
                }
                if (clazz == Character.TYPE) {
                    return 31.0;
                }
                if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return 32.0;
                }
                if (clazz == Boolean.TYPE) {
                    return 33.0;
                }
                if (clazz != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) break;
                return 34.0;
            }
            case 1: 
            case 4: {
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
                    return 0.0;
                }
                if (clazz == Character.TYPE) {
                    return 1.0;
                }
                if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return 2.0;
                }
                if (clazz == Double.TYPE) {
                    return 10.0;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 11.0;
                }
                if (clazz == Float.TYPE) {
                    return 12.0;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 13.0;
                }
                if (clazz == Integer.TYPE) {
                    return 14.0;
                }
                if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return 15.0;
                }
                if (clazz == Long.TYPE) {
                    return 16.0;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return 17.0;
                }
                if (clazz == Short.TYPE) {
                    return 18.0;
                }
                if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return 19.0;
                }
                if (clazz == Byte.TYPE) {
                    return 20.0;
                }
                if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return 21.0;
                }
                if (clazz == Boolean.TYPE) {
                    return 30.0;
                }
                if (clazz != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) break;
                return 31.0;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public Object toJavaObject(Class clazz) throws EvalException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Value.class$("java.lang.Object")) : class$java$lang$Object)) {
            switch (this.type) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.event.value;
                }
                case 2: {
                    return new Boolean(this.bool);
                }
                case 3: {
                    return new Double(this.number);
                }
                case 4: {
                    return this.string;
                }
                case 5: {
                    return this.object;
                }
            }
            throw new RuntimeException("Fatal: unexpected type " + this.type);
        }
        if (this.type == 5 && (this.object == null || clazz.isAssignableFrom(this.object.getClass()))) {
            return this.object;
        }
        if (clazz == (class$java$util$List == null ? (class$java$util$List = Value.class$("java.util.List")) : class$java$util$List)) {
            if (this.type == 0) {
                return new ArrayList(0);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Value value = this;
            while (value != null) {
                arrayList.add(value.toJavaObject(class$java$lang$Object == null ? Value.class$("java.lang.Object") : class$java$lang$Object));
                value = value.next;
            }
            return arrayList;
        }
        if (this.type == 0 && !clazz.isPrimitive()) {
            return null;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Value.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getStringValue();
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Value.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(this.getBooleanValue());
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Value.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.getNumberValue());
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Value.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.getNumberValue());
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Value.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.getNumberValue());
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Value.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)this.getNumberValue());
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Value.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.getNumberValue());
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Value.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.getNumberValue());
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Value.class$("java.lang.Character")) : class$java$lang$Character)) {
            String string = this.getStringValue();
            if (this.string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new EvalException("Cannot convert string `" + this.string + "' to character (length is not 1)");
        }
        throw new EvalException("Conversion to " + clazz.getName() + " is not supported");
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = "()";
                break;
            }
            case 3: {
                string = "number " + this.number;
                break;
            }
            case 2: {
                string = "boolean " + this.bool;
                break;
            }
            case 4: {
                string = "string '" + this.string + "'";
                break;
            }
            case 1: {
                string = "node " + this.event;
                break;
            }
            case 5: {
                string = "object " + this.object;
                break;
            }
            default: {
                string = "unknown type in Value object";
            }
        }
        if (this.next != null) {
            string = string + ", " + this.next.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(325);
        VAL_TRUE = new Value(true);
        VAL_FALSE = new Value(false);
        VAL_EMPTY = new Value();
        VAL_EMPTY_STRING = new Value("");
        VAL_ZERO = new Value(0.0);
        VAL_NAN = new Value(Double.NaN);
    }
}

