/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx.function;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Value;
import net.sf.joost.stx.function.FunctionFactory;
import org.xml.sax.SAXException;

public final class EscapeUri
implements FunctionFactory.Instance {
    public int getMinParCount() {
        return 2;
    }

    public int getMaxParCount() {
        return 2;
    }

    public String getName() {
        return "{http://stx.sourceforge.net/2003/functions}escape-uri";
    }

    public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
        Value value = tree.left.evaluate(context, n);
        String string = value.getStringValue();
        boolean bl = tree.right.evaluate(context, n).getBooleanValue();
        try {
            char[] cArray = string.toCharArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] >= 'A' && cArray[i] <= 'Z' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] >= '\'' && cArray[i] <= '*' || "%#-_.!~".indexOf(cArray[i]) != -1) {
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                if (!bl && ";/?:@&=+$,[]".indexOf(cArray[i]) != -1) {
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                outputStreamWriter.write(cArray[i]);
                outputStreamWriter.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                for (int j = 0; j < byArray.length; ++j) {
                    int n2 = byArray[j] >>> 4 & 0xF;
                    stringBuffer.append('%').append(n2 < 10 ? (char)(48 + n2) : (char)(65 + n2 - 10));
                    n2 = byArray[j] & 0xF;
                    stringBuffer.append(n2 < 10 ? (char)(48 + n2) : (char)(65 + n2 - 10));
                }
                byteArrayOutputStream.reset();
            }
            return new Value(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new EvalException("Fatal: " + iOException.toString());
        }
    }
}

