/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx.function;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Value;
import net.sf.joost.stx.function.FunctionFactory;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ExtensionFunction
implements FunctionFactory.Instance {
    private Class targetClass;
    private ArrayList candidateMethods = new ArrayList();
    private int paramCount = 0;
    private boolean isConstructor;

    ExtensionFunction(String string, String string2, Tree tree, Locator locator) throws SAXParseException {
        try {
            this.targetClass = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXParseException("Can't find Java class " + classNotFoundException.getMessage(), locator);
        }
        if (tree != null) {
            this.paramCount = 1;
            while (tree.type == 34) {
                tree = tree.left;
                ++this.paramCount;
            }
        }
        String string3 = string2;
        if (string2.equals("new")) {
            this.isConstructor = true;
            int n = this.targetClass.getModifiers();
            if (Modifier.isAbstract(n)) {
                throw new SAXParseException("Cannot create an object, class " + this.targetClass + " is abstract", locator);
            }
            if (Modifier.isInterface(n)) {
                throw new SAXParseException("Cannot create an object, " + this.targetClass + " is an interface", locator);
            }
            if (Modifier.isPrivate(n)) {
                throw new SAXParseException("Cannot create an object, class " + this.targetClass + " is private", locator);
            }
            if (Modifier.isProtected(n)) {
                throw new SAXParseException("Cannot create an object, class " + this.targetClass + " is protected", locator);
            }
            Constructor<?>[] constructorArray = this.targetClass.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor = constructorArray[i];
                if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != this.paramCount) continue;
                this.candidateMethods.add(constructor);
            }
            if (this.candidateMethods.size() == 0) {
                throw new SAXParseException("No constructor found with " + this.paramCount + " parameter" + (this.paramCount != 1 ? "s" : "") + " in class " + string, locator);
            }
        } else {
            char c;
            int n;
            Method[] methodArray;
            if (string2.indexOf(45) >= 0) {
                methodArray = new StringBuffer();
                n = 0;
                for (int i = 0; i < string2.length(); ++i) {
                    c = string2.charAt(i);
                    if (c == '-') {
                        n = 1;
                        continue;
                    }
                    if (n != 0) {
                        methodArray.append(Character.toUpperCase(c));
                    } else {
                        methodArray.append(c);
                    }
                    n = 0;
                }
                string3 = methodArray.toString();
            }
            methodArray = this.targetClass.getMethods();
            for (n = 0; n < methodArray.length; ++n) {
                Method method = methodArray[n];
                if (!method.getName().equals(string3) || !Modifier.isPublic(c = method.getModifiers())) continue;
                int n2 = this.paramCount;
                if (!Modifier.isStatic(c)) {
                    --n2;
                }
                if (method.getParameterTypes().length != n2) continue;
                this.candidateMethods.add(method);
            }
            if (this.candidateMethods.size() == 0) {
                throw new SAXParseException("No function found matching `" + string3 + "' " + (string2.equals(string3) ? "" : "(" + string2 + ") ") + "with " + this.paramCount + " parameter" + (this.paramCount != 1 ? "s" : "") + " in class " + string, locator);
            }
        }
    }

    public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
        int n2;
        Value[] valueArray = null;
        if (this.paramCount > 0) {
            valueArray = new Value[this.paramCount];
            for (int i = this.paramCount - 1; i > 0; --i) {
                valueArray[i] = tree.right.evaluate(context, n);
                tree = tree.left;
            }
            valueArray[0] = tree.evaluate(context, n);
        }
        if (this.isConstructor) {
            int n3;
            Constructor constructor = null;
            int n4 = this.candidateMethods.size();
            if (n4 == 1) {
                constructor = (Constructor)this.candidateMethods.get(0);
            } else {
                double d = -1.0;
                n3 = 0;
                for (int i = 0; i < n4; ++i) {
                    Constructor constructor2 = (Constructor)this.candidateMethods.get(i);
                    double d2 = 0.0;
                    Class<?>[] classArray = constructor2.getParameterTypes();
                    for (int j = 0; j < classArray.length; ++j) {
                        d2 += valueArray[j].getDistanceTo(classArray[j]);
                    }
                    if (d2 < d || d < 0.0) {
                        d = d2;
                        constructor = constructor2;
                        n3 = 0;
                        continue;
                    }
                    if (d2 != d) continue;
                    n3 = 1;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    throw new EvalException("None of the Java constructors in " + this.targetClass.getName() + " matches this function call to `new'");
                }
                if (n3 != 0) {
                    throw new EvalException("There are several Java constructors in " + this.targetClass.getName() + " that match the function call to `new' equally well ");
                }
            }
            Class<?>[] classArray = constructor.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            for (n3 = 0; n3 < classArray.length; ++n3) {
                objectArray[n3] = valueArray[n3].toJavaObject(classArray[n3]);
            }
            try {
                Object t = constructor.newInstance(objectArray);
                return new Value(t);
            }
            catch (InstantiationException instantiationException) {
                throw new EvalException("Cannot instantiate class " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EvalException("Constructor access is illegal " + illegalAccessException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new EvalException("Argument is of wrong type " + illegalArgumentException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new EvalException("Exception in extension constructor " + constructor.getName() + ": " + invocationTargetException.getTargetException().toString());
            }
        }
        Method method = null;
        int n5 = this.candidateMethods.size();
        if (n5 == 1) {
            method = (Method)this.candidateMethods.get(0);
        } else {
            double d = -1.0;
            boolean bl = false;
            for (n2 = 0; n2 < n5; ++n2) {
                int n6;
                Method method2 = (Method)this.candidateMethods.get(n2);
                double d3 = 0.0;
                Class<?>[] classArray = method2.getParameterTypes();
                if (Modifier.isStatic(method2.getModifiers())) {
                    for (n6 = 0; n6 < classArray.length; ++n6) {
                        d3 += valueArray[n6].getDistanceTo(classArray[n6]);
                    }
                } else {
                    d3 = valueArray[0].getDistanceTo(this.targetClass);
                    for (n6 = 0; n6 < classArray.length; ++n6) {
                        d3 += valueArray[n6 + 1].getDistanceTo(classArray[n6]);
                    }
                }
                if (d3 < d || d < 0.0) {
                    d = d3;
                    method = method2;
                    bl = false;
                    continue;
                }
                if (d3 != d) continue;
                bl = true;
            }
            if (d == Double.POSITIVE_INFINITY) {
                throw new EvalException("None of the Java methods in " + this.targetClass.getName() + " matches this function call to `" + method.getName() + "'");
            }
            if (bl) {
                throw new EvalException("There are several Java methods in " + this.targetClass.getName() + " that match function `" + method.getName() + "' equally well");
            }
        }
        Object object = null;
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        if (Modifier.isStatic(method.getModifiers())) {
            for (n2 = 0; n2 < classArray.length; ++n2) {
                objectArray[n2] = valueArray[n2].toJavaObject(classArray[n2]);
            }
        } else {
            if (n5 == 1 && valueArray[0].getDistanceTo(this.targetClass) == Double.POSITIVE_INFINITY) {
                throw new EvalException("First parameter in the function call to `" + method.getName() + "' must be the object instance");
            }
            object = valueArray[0].toJavaObject(this.targetClass);
            if (object == null) {
                throw new EvalException("Target object (first parameter) in the function call to `" + method.getName() + "' is null");
            }
            for (n2 = 0; n2 < classArray.length; ++n2) {
                objectArray[n2] = valueArray[n2 + 1].toJavaObject(classArray[n2]);
            }
        }
        try {
            return new Value(method.invoke(object, objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new EvalException("Method access is illegal " + illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new EvalException("Argument is of wrong type " + illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EvalException("Exception in extension method `" + method.getName() + "': " + invocationTargetException.getTargetException().toString());
        }
    }

    public int getMinParCount() {
        return 0;
    }

    public int getMaxParCount() {
        return 0;
    }

    public String getName() {
        return null;
    }
}

