/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx.function;

import net.sf.joost.grammar.EvalException;
import net.sf.joost.grammar.Tree;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.Value;
import net.sf.joost.stx.function.FunctionFactory;
import org.xml.sax.SAXException;

public final class Substring
implements FunctionFactory.Instance {
    public int getMinParCount() {
        return 2;
    }

    public int getMaxParCount() {
        return 3;
    }

    public String getName() {
        return "{http://stx.sourceforge.net/2003/functions}substring";
    }

    public Value evaluate(Context context, int n, Tree tree) throws SAXException, EvalException {
        try {
            if (tree.left.type == 34) {
                String string = tree.left.left.evaluate(context, n).getStringValue();
                double d = tree.left.right.evaluate(context, n).getNumberValue();
                double d2 = tree.right.evaluate(context, n).getNumberValue();
                if (Double.isNaN(d) || Double.isNaN(d + d2)) {
                    return Value.VAL_EMPTY_STRING;
                }
                int n2 = Math.round((float)(d - 1.0));
                int n3 = n2 + Math.round((float)d2);
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n3 > string.length()) {
                    n3 = string.length();
                }
                if (n2 > n3) {
                    return Value.VAL_EMPTY_STRING;
                }
                return new Value(string.substring(n2, n3));
            }
            String string = tree.left.evaluate(context, n).getStringValue();
            double d = tree.right.evaluate(context, n).getNumberValue();
            if (Double.isNaN(d)) {
                return Value.VAL_EMPTY_STRING;
            }
            if (d < 1.0) {
                return new Value(string);
            }
            int n4 = Math.round((float)(d - 1.0));
            if (n4 > string.length()) {
                return Value.VAL_EMPTY_STRING;
            }
            return new Value(string.substring(n4));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SAXException(indexOutOfBoundsException);
        }
    }
}

