/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trace;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import net.sf.joost.OptionalLog;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Emitter;
import net.sf.joost.stx.ErrorHandlerImpl;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.trace.TraceManager;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class DebugEmitter
extends Emitter {
    private static Log log = OptionalLog.getLog(class$net$sf$joost$trace$DebugEmitter == null ? (class$net$sf$joost$trace$DebugEmitter = DebugEmitter.class$("net.sf.joost.trace.DebugEmitter")) : class$net$sf$joost$trace$DebugEmitter);
    private TraceManager tmgr;
    private LocatorImpl locator = new LocatorImpl();
    public DebugWriter writer;
    static /* synthetic */ Class class$net$sf$joost$trace$DebugEmitter;

    public DebugEmitter(ErrorHandlerImpl errorHandlerImpl) {
        super(errorHandlerImpl);
    }

    private DebugEmitter(DebugEmitter debugEmitter, StxEmitter stxEmitter) {
        super(debugEmitter, stxEmitter);
        this.tmgr = debugEmitter.tmgr;
        this.writer = debugEmitter.writer;
    }

    public Emitter pushEmitter(StxEmitter stxEmitter) {
        return new DebugEmitter(this, stxEmitter);
    }

    public void setTraceManager(TraceManager traceManager) {
        this.tmgr = traceManager;
    }

    public TraceManager getTraceManager() {
        return this.tmgr;
    }

    public Locator getEmitterLocator() {
        return this.locator;
    }

    public Writer getResultWriter(String string, String string2, String string3, String string4, int n, int n2, boolean bl) throws IOException, SAXException {
        if (log != null) {
            log.debug((Object)("requesting writer for " + string));
        }
        this.writer = new DebugWriter(string);
        return this.writer;
    }

    public void startDocument() throws SAXException {
        if (log != null) {
            log.debug((Object)"start resultdocument");
        }
        this.updateLocator(null, null, -1, -1);
        this.tmgr.fireStartResultDocument();
    }

    public void endDocument(AbstractInstruction abstractInstruction) throws SAXException {
        if (log != null) {
            log.debug((Object)"end resultdocument");
        }
        super.endDocument(abstractInstruction);
        this.updateLocator(abstractInstruction.getNode().publicId, abstractInstruction.getNode().systemId, abstractInstruction.lineNo, abstractInstruction.colNo);
        this.tmgr.fireEndResultDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable, NodeBase nodeBase) throws SAXException {
        if (log != null) {
            log.debug((Object)"start element in resultdoc");
        }
        SAXEvent sAXEvent = SAXEvent.newElement(string, string2, string3, attributes, true, hashtable);
        super.startElement(string, string2, string3, attributes, hashtable, nodeBase);
        this.updateLocator(nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        this.tmgr.fireStartResultElement(sAXEvent);
    }

    public void endElement(String string, String string2, String string3, AbstractInstruction abstractInstruction) throws SAXException {
        if (log != null) {
            log.debug((Object)"end element in resultdoc");
        }
        SAXEvent sAXEvent = SAXEvent.newElement(string, string2, string3, null, true, null);
        this.updateLocator(abstractInstruction.getNode().publicId, abstractInstruction.getNode().systemId, abstractInstruction.lineNo, abstractInstruction.colNo);
        super.endElement(string, string2, string3, abstractInstruction);
        this.tmgr.fireEndResultElement(sAXEvent);
    }

    public void characters(char[] cArray, int n, int n2, NodeBase nodeBase) throws SAXException {
        if (log != null) {
            log.debug((Object)"characters in resultdoc");
        }
        SAXEvent sAXEvent = SAXEvent.newText(new String(cArray, n, n2));
        super.characters(cArray, n, n2, nodeBase);
        this.updateLocator(nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        this.tmgr.fireResultText(sAXEvent);
    }

    public void processingInstruction(String string, String string2, NodeBase nodeBase) throws SAXException {
        if (log != null) {
            log.debug((Object)"processingInstruction in resultdoc");
        }
        SAXEvent sAXEvent = SAXEvent.newPI(string, string2);
        super.processingInstruction(string, string2, nodeBase);
        this.updateLocator(nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        this.tmgr.fireResultPI(sAXEvent);
    }

    public void comment(char[] cArray, int n, int n2, NodeBase nodeBase) throws SAXException {
        if (log != null) {
            log.debug((Object)"comment in resultdoc");
        }
        SAXEvent sAXEvent = SAXEvent.newComment(new String(cArray, n, n2));
        super.comment(cArray, n, n2, nodeBase);
        this.updateLocator(nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        this.tmgr.fireResultComment(sAXEvent);
    }

    public void startCDATA(NodeBase nodeBase) throws SAXException {
        if (log != null) {
            log.debug((Object)"start CDATA in resultdoc");
        }
        super.startCDATA(nodeBase);
        this.updateLocator(nodeBase.publicId, nodeBase.systemId, nodeBase.lineNo, nodeBase.colNo);
        this.tmgr.fireStartResultCDATA();
    }

    public void endCDATA() throws SAXException {
        if (log != null) {
            log.debug((Object)"end CDATA in resultdoc");
        }
        super.endCDATA();
        this.updateLocator(null, null, -1, -1);
        this.tmgr.fireEndResultCDATA();
    }

    private void updateLocator(String string, String string2, int n, int n2) {
        if (log != null) {
            log.debug((Object)("update emitterlocator " + string + " " + string2 + " " + n + "," + n2));
        }
        this.locator.setPublicId(string);
        this.locator.setSystemId(string2);
        this.locator.setLineNumber(n);
        this.locator.setColumnNumber(n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DebugWriter
    extends StringWriter {
        private String href;

        public DebugWriter(String string) {
            this.href = string;
        }

        public String getHref() {
            return this.href;
        }
    }
}

