/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trace;

import java.util.Vector;
import net.sf.joost.instruction.AbstractInstruction;
import net.sf.joost.stx.SAXEvent;
import net.sf.joost.trace.TraceListener;
import net.sf.joost.trax.TransformerImpl;

public class TraceManager {
    private Vector traceListeners = null;

    public boolean hasTraceListeners() {
        return this.traceListeners != null;
    }

    public void addTraceListener(TraceListener traceListener) {
        TransformerImpl.DEBUG_MODE = true;
        if (this.traceListeners == null) {
            this.traceListeners = new Vector();
        }
        this.traceListeners.addElement(traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (this.traceListeners != null) {
            this.traceListeners.removeElement(traceListener);
        }
    }

    public void fireStartSourceDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.startSourceDocument();
            }
        }
    }

    public void fireEndSourceDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.endSourceDocument();
            }
        }
    }

    public void fireStartSourceElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.startSourceElement(sAXEvent);
            }
        }
    }

    public void fireEndSourceElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.endSourceElement(sAXEvent);
            }
        }
    }

    public void fireSourceText(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.sourceText(sAXEvent);
            }
        }
    }

    public void fireSourcePI(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.sourcePI(sAXEvent);
            }
        }
    }

    public void fireSourceMapping(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.sourceMapping(sAXEvent);
            }
        }
    }

    public void fireSourceComment(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.sourceComment(sAXEvent);
            }
        }
    }

    public void fireEnterInstructionNode(AbstractInstruction abstractInstruction, SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.enterInstructionNode(abstractInstruction, sAXEvent);
            }
        }
    }

    public void fireLeaveInstructionNode(AbstractInstruction abstractInstruction, SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.leaveInstructionNode(abstractInstruction, sAXEvent);
            }
        }
    }

    public void fireStartResultDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.startResultDocument();
            }
        }
    }

    public void fireEndResultDocument() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.endResultDocument();
            }
        }
    }

    public void fireStartResultElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.startResultElement(sAXEvent);
            }
        }
    }

    public void fireEndResultElement(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.endResultElement(sAXEvent);
            }
        }
    }

    public void fireResultText(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.resultText(sAXEvent);
            }
        }
    }

    public void fireResultPI(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.resultPI(sAXEvent);
            }
        }
    }

    public void fireResultComment(SAXEvent sAXEvent) {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.resultComment(sAXEvent);
            }
        }
    }

    public void fireStartResultCDATA() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.startResultCDATA();
            }
        }
    }

    public void fireEndResultCDATA() {
        if (this.hasTraceListeners()) {
            int n = this.traceListeners.size();
            for (int i = 0; i < n; ++i) {
                TraceListener traceListener = (TraceListener)this.traceListeners.elementAt(i);
                traceListener.endResultCDATA();
            }
        }
    }
}

