/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trax;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.joost.OptionalLog;
import net.sf.joost.emitter.DOMEmitter;
import net.sf.joost.emitter.SAXEmitter;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.stx.Processor;
import net.sf.joost.trax.DOMDriver;
import net.sf.joost.trax.TrAXConstants;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class TrAXHelper
implements TrAXConstants {
    private static Log log = OptionalLog.getLog(class$net$sf$joost$trax$TrAXHelper == null ? (class$net$sf$joost$trax$TrAXHelper = TrAXHelper.class$("net.sf.joost.trax.TrAXHelper")) : class$net$sf$joost$trax$TrAXHelper);
    static /* synthetic */ Class class$net$sf$joost$trax$TrAXHelper;

    protected TrAXHelper() {
    }

    protected static InputSource getInputSourceForStreamSources(Source source, ErrorListener errorListener) throws TransformerConfigurationException {
        InputSource inputSource = null;
        String string = source.getSystemId();
        if (string == null) {
            string = "";
        }
        try {
            if (source instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)source;
                InputStream inputStream = streamSource.getInputStream();
                Reader reader = streamSource.getReader();
                inputSource = inputStream != null ? new InputSource(inputStream) : (reader != null ? new InputSource(reader) : new InputSource(string));
            } else {
                if (errorListener != null) {
                    try {
                        errorListener.fatalError(new TransformerConfigurationException("Source is not a StreamSource"));
                        return null;
                    }
                    catch (TransformerException transformerException) {
                        throw new TransformerConfigurationException("Source is not a StreamSource");
                    }
                }
                throw new TransformerConfigurationException("Source is not a StreamSource");
            }
            inputSource.setSystemId(string);
        }
        catch (SecurityException securityException) {
            if (errorListener != null) {
                try {
                    errorListener.fatalError(new TransformerConfigurationException(securityException));
                    return null;
                }
                catch (TransformerException transformerException) {
                    throw new TransformerConfigurationException(securityException.getMessage());
                }
            }
            throw new TransformerConfigurationException(securityException.getMessage());
        }
        return inputSource;
    }

    public static StxEmitter initStxEmitter(Result result, Processor processor) throws TransformerException {
        try {
            if (result instanceof SAXResult) {
                SAXResult sAXResult = (SAXResult)result;
                ContentHandler contentHandler = sAXResult.getHandler();
                if (contentHandler != null) {
                    return new SAXEmitter(contentHandler);
                }
            } else {
                if (result instanceof DOMResult) {
                    return new DOMEmitter();
                }
                if (result instanceof StreamResult) {
                    StreamResult streamResult = (StreamResult)result;
                    Writer writer = streamResult.getWriter();
                    if (writer != null) {
                        return StreamEmitter.newEmitter(writer, "UTF-8", processor.outputProperties);
                    }
                    OutputStream outputStream = streamResult.getOutputStream();
                    if (outputStream != null) {
                        return StreamEmitter.newEmitter(outputStream, processor.outputProperties);
                    }
                    String string = result.getSystemId();
                    if (string == null) {
                        throw new TransformerException("JAXP_NO_RESULT_ERR");
                    }
                    OutputStream outputStream2 = null;
                    URL uRL = null;
                    if (string.startsWith("file:")) {
                        uRL = new URL(string);
                        outputStream2 = new FileOutputStream(uRL.getFile());
                        return StreamEmitter.newEmitter(outputStream2, processor.outputProperties);
                    }
                    if (string.startsWith("http:")) {
                        uRL = new URL(string);
                        URLConnection uRLConnection = uRL.openConnection();
                        outputStream2 = uRLConnection.getOutputStream();
                        return StreamEmitter.newEmitter(outputStream2, processor.outputProperties);
                    }
                    File file = new File(string);
                    uRL = file.toURL();
                    outputStream2 = new FileOutputStream(uRL.getFile());
                    return StreamEmitter.newEmitter(outputStream2, processor.outputProperties);
                }
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformerException(parserConfigurationException);
        }
        return null;
    }

    public static SAXSource getSAXSource(Source source, ErrorListener errorListener) throws TransformerException {
        if (source instanceof SAXSource) {
            return (SAXSource)source;
        }
        if (source instanceof DOMSource) {
            InputSource inputSource = new InputSource();
            Node node = ((DOMSource)source).getNode();
            Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
            DOMDriver dOMDriver = new DOMDriver();
            dOMDriver.setDocument(document);
            inputSource.setSystemId(source.getSystemId());
            dOMDriver.setSystemId(source.getSystemId());
            return new SAXSource(dOMDriver, inputSource);
        }
        if (source instanceof StreamSource) {
            InputSource inputSource = TrAXHelper.getInputSourceForStreamSources(source, errorListener);
            return new SAXSource(inputSource);
        }
        String string = "Unknown type of source";
        if (log != null) {
            log.error((Object)string);
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(illegalArgumentException.getMessage(), illegalArgumentException);
        if (errorListener == null) {
            throw transformerConfigurationException;
        }
        errorListener.error(transformerConfigurationException);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

