/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trax;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.joost.Constants;
import net.sf.joost.OptionalLog;
import net.sf.joost.emitter.DOMEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.stx.Processor;
import net.sf.joost.trax.TrAXHelper;
import net.sf.joost.trax.TransformerImpl;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TransformerHandlerImpl
implements TransformerHandler,
Constants {
    private static Log log = OptionalLog.getLog(class$net$sf$joost$trax$TransformerHandlerImpl == null ? (class$net$sf$joost$trax$TransformerHandlerImpl = TransformerHandlerImpl.class$("net.sf.joost.trax.TransformerHandlerImpl")) : class$net$sf$joost$trax$TransformerHandlerImpl);
    private Processor processor = null;
    private Transformer transformer = null;
    private StxEmitter stxEmitter = null;
    private String systemId = null;
    private Result result = null;
    static /* synthetic */ Class class$net$sf$joost$trax$TransformerHandlerImpl;

    protected TransformerHandlerImpl(Transformer transformer) {
        this.transformer = transformer;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setResult(Result result) throws IllegalArgumentException {
        try {
            this.result = result;
            this.init(result);
        }
        catch (TransformerException transformerException) {
            if (this.transformer instanceof TransformerImpl) {
                TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(transformerException.getMessage(), transformerException);
                try {
                    ((TransformerImpl)this.transformer).defaultErrorListener.fatalError(transformerConfigurationException);
                }
                catch (TransformerException transformerException2) {
                    throw new IllegalArgumentException(transformerException2.getMessage());
                }
            }
            if (log != null) {
                log.fatal((Object)transformerException);
            }
            throw new IllegalArgumentException("result is invalid.");
        }
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    private void init(Result result) throws TransformerException {
        if (this.transformer instanceof TransformerImpl) {
            this.processor = ((TransformerImpl)this.transformer).getStxProcessor();
            this.stxEmitter = TrAXHelper.initStxEmitter(result, this.processor);
            this.stxEmitter.setSystemId(result.getSystemId());
            this.processor.setContentHandler(this.stxEmitter);
            this.processor.setLexicalHandler(this.stxEmitter);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.processor.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.processor.startDocument();
    }

    public void endDocument() throws SAXException {
        this.processor.endDocument();
        if (this.result instanceof DOMResult) {
            Node node = ((DOMEmitter)this.stxEmitter).getDOMTree();
            ((DOMResult)this.result).setNode(node);
            return;
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.processor.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.processor.endPrefixMapping(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.processor.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.processor.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.processor.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.processor.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.processor.processingInstruction(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
        this.processor.skippedEntity(string);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.processor.startDTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.processor.endDTD();
    }

    public void startEntity(String string) throws SAXException {
        this.processor.startEntity(string);
    }

    public void endEntity(String string) throws SAXException {
        this.processor.endEntity(string);
    }

    public void startCDATA() throws SAXException {
        this.processor.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.processor.endCDATA();
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.processor.comment(cArray, n, n2);
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

