/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trax;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.joost.OptionalLog;
import net.sf.joost.emitter.DOMEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.stx.Emitter;
import net.sf.joost.stx.Processor;
import net.sf.joost.trace.DebugEmitter;
import net.sf.joost.trace.DebugProcessor;
import net.sf.joost.trace.TraceManager;
import net.sf.joost.trax.TrAXConstants;
import net.sf.joost.trax.TrAXHelper;
import net.sf.joost.trax.TransformationErrListener;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TransformerImpl
extends Transformer
implements TrAXConstants {
    private static Log log = OptionalLog.getLog(class$net$sf$joost$trax$TransformerImpl == null ? (class$net$sf$joost$trax$TransformerImpl = TransformerImpl.class$("net.sf.joost.trax.TransformerImpl")) : class$net$sf$joost$trax$TransformerImpl);
    private Processor processor = null;
    private URIResolver uriRes = null;
    private ErrorListener errorListener = null;
    protected TransformationErrListener defaultErrorListener = new TransformationErrListener();
    private HashSet supportedProperties = new HashSet();
    private Boolean reentryGuard = new Boolean(true);
    public static boolean DEBUG_MODE = false;
    public boolean cancelTransformation = false;
    private TraceManager traceManager = new TraceManager();
    static /* synthetic */ Class class$net$sf$joost$trax$TransformerImpl;

    protected TransformerImpl(Processor processor) {
        this.processor = processor;
        if (processor instanceof DebugProcessor) {
            DebugProcessor debugProcessor = (DebugProcessor)processor;
            debugProcessor.setTraceManager(this.traceManager);
            debugProcessor.setTransformer(this);
            Emitter emitter = processor.getEmitter();
            if (emitter instanceof DebugEmitter) {
                ((DebugEmitter)emitter).setTraceManager(this.traceManager);
            }
        }
        this.supportedProperties.add("encoding");
        this.supportedProperties.add("media-type");
        this.supportedProperties.add("method");
        this.supportedProperties.add("omit-xml-declaration");
        this.supportedProperties.add("standalone");
        this.supportedProperties.add("version");
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Source source, Result result) throws TransformerException {
        StxEmitter stxEmitter = null;
        SAXSource sAXSource = null;
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            try {
                InputSource inputSource;
                stxEmitter = TrAXHelper.initStxEmitter(result, this.processor);
                stxEmitter.setSystemId(result.getSystemId());
                this.processor.setContentHandler(stxEmitter);
                this.processor.setLexicalHandler(stxEmitter);
                if (this.errorListener != null) {
                    this.processor.setErrorListener(this.errorListener);
                }
                if ((inputSource = (sAXSource = TrAXHelper.getSAXSource(source, this.errorListener)).getInputSource()) != null) {
                    if (sAXSource.getXMLReader() != null && source instanceof SAXSource) {
                        XMLReader xMLReader = ((SAXSource)source).getXMLReader();
                        if (xMLReader != null) {
                            try {
                                xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                                xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                            }
                            catch (SAXException sAXException) {
                                this.defaultErrorListener.warning(new TransformerException(sAXException.getMessage(), sAXException));
                            }
                        }
                        this.processor.setParent(sAXSource.getXMLReader());
                    }
                    this.processor.parse(inputSource);
                } else {
                    TransformerException transformerException = new TransformerException("InputSource is null - could not perform transformation");
                    this.defaultErrorListener.fatalError(transformerException);
                }
                this.performResults(result, stxEmitter);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                TransformerException transformerException = exception instanceof TransformerException ? (TransformerException)exception : new TransformerException(sAXException.getMessage(), sAXException);
                this.defaultErrorListener.fatalError(transformerException);
            }
            catch (IOException iOException) {
                this.defaultErrorListener.fatalError(new TransformerException(iOException.getMessage(), iOException));
            }
        }
    }

    private void performResults(Result result, StxEmitter stxEmitter) {
        if (result instanceof DOMResult) {
            Node node = ((DOMEmitter)stxEmitter).getDOMTree();
            ((DOMResult)result).setNode(node);
            return;
        }
        if (result instanceof StreamResult) {
            return;
        }
        if (result instanceof SAXResult) {
            return;
        }
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        if (this.supportedProperties.contains(string)) {
            return this.processor.outputProperties.getProperty(string);
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unsupported property " + string);
        if (log != null) {
            log.error((Object)illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        throw illegalArgumentException;
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        if (this.supportedProperties.contains(string)) {
            if ("method".equals(string) && !string2.startsWith("{") && !"xml".equals(string2) && !"text".equals(string2)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unsupported output method " + string2);
                if (log != null) {
                    log.error((Object)illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
                }
                throw illegalArgumentException;
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unsupported property " + string);
            if (log != null) {
                log.error((Object)illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        this.processor.outputProperties.setProperty(string, string2);
    }

    public Properties getOutputProperties() {
        return (Properties)this.processor.outputProperties.clone();
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            this.processor.initOutputProperties();
        } else {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (!this.supportedProperties.contains(object)) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unsupported property " + object);
                    if (log != null) {
                        log.error((Object)illegalArgumentException);
                    }
                    throw illegalArgumentException;
                }
                if (!"method".equals(object) || "xml".equals(properties.getProperty((String)object))) continue;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unsupported output method " + properties.getProperty((String)object));
                if (log != null) {
                    log.error((Object)illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.processor.outputProperties = (Properties)properties.clone();
        }
    }

    public URIResolver getURIResolver() {
        return this.uriRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURIResolver(URIResolver uRIResolver) {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            this.uriRes = uRIResolver;
            this.processor.setURIResolver(uRIResolver);
        }
    }

    public void clearParameters() {
        this.processor.clearParameters();
    }

    public void setParameter(String string, Object object) {
        this.processor.setParameter(string, object);
    }

    public Object getParameter(String string) {
        return this.processor.getParameter(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            this.errorListener = errorListener;
        }
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public Processor getStxProcessor() {
        return this.processor;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

