/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ExportCleaner {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: ExportCleaner input.xml output.xml");
            System.exit(-1);
        }
        String file = args[0];
        SAXReader reader = new SAXReader();
        FileInputStream inputStream = new FileInputStream(file);
        Document document = reader.read((InputStream)inputStream);
        List nodes = document.selectNodes("//property");
        int cleanedElements = 0;
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Element el = (Element)iterator.next();
            Element parent = el.getParent();
            if (!ExportCleaner.validElement(parent)) continue;
            if ("content".equals(el.attributeValue("name"))) {
                el.clearContent();
                el.add((CDATA)new DOMCDATA("content-stripped-by-exportcleaner"));
                ++cleanedElements;
                continue;
            }
            if (!"title".equals(el.attributeValue("name"))) continue;
            el.clearContent();
            el.add((CDATA)new DOMCDATA("title-stripped-" + cleanedElements));
            ++cleanedElements;
        }
        FileOutputStream out = new FileOutputStream(args[1], false);
        OutputFormat format = new OutputFormat();
        format.setEncoding("UTF8");
        XMLWriter writer = new XMLWriter((OutputStream)out, format);
        writer.write(document);
        writer.close();
        out.flush();
        out.close();
        System.out.println("Cleaned : " + cleanedElements + " pieces of text.");
    }

    private static boolean validElement(Element parent) {
        return "Mail".equals(parent.attributeValue("class")) || "Page".equals(parent.attributeValue("class")) || "BlogPost".equals(parent.attributeValue("class")) || "Comment".equals(parent.attributeValue("class")) || "SpaceDescription".equals(parent.attributeValue("class"));
    }
}

