/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.ldaptemplate.BadLdapGrammarException;
import net.sf.ldaptemplate.support.LdapEncoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapRdn {
    private String key;
    private String value;
    private String ldapEncoded;
    protected static final Pattern RDN_PATTERN = Pattern.compile("\\s*(\\p{Alnum}+)\\s*=\\s*((\\\\\\p{XDigit}{2}|\\\\.|[^\\\\])+?)\\s*");
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.ldaptemplate.support.LdapRdn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public LdapRdn(String ldapRdn) throws BadLdapGrammarException {
        this.parseLdap(ldapRdn);
    }

    public LdapRdn(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Key may not be blank");
        }
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException("Value may not be blank");
        }
        this.key = key.toLowerCase();
        this.value = value;
        this.ldapEncoded = this.encodeLdap();
    }

    protected String encodeLdap() {
        StringBuffer buff = new StringBuffer(this.key.length() + this.value.length() * 2);
        buff.append(this.key);
        buff.append('=');
        buff.append(LdapEncoder.nameEncode(this.value));
        return buff.toString();
    }

    protected void parseLdap(String rdn) throws BadLdapGrammarException {
        Matcher matcher = RDN_PATTERN.matcher(rdn);
        if (!matcher.matches()) {
            throw new BadLdapGrammarException("Not a proper name (such as key=value): " + rdn);
        }
        String rawKey = matcher.group(1);
        String rawValue = matcher.group(2);
        this.key = StringUtils.lowerCase((String)rawKey);
        this.value = LdapEncoder.nameDecode(rawValue);
        if (this.key == null) {
            throw new BadLdapGrammarException("Key empty in rdn '" + rdn + "'");
        }
        if (this.value == null) {
            throw new BadLdapGrammarException("Value empty in rdn '" + rdn + "'");
        }
        this.ldapEncoded = this.encodeLdap();
    }

    public static LdapRdn parse(String rdn) {
        try {
            return new LdapRdn(rdn);
        }
        catch (BadLdapGrammarException e) {
            return null;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.ldapEncoded;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LdapRdn rdn = (LdapRdn)obj;
        return StringUtils.equalsIgnoreCase((String)rdn.key, (String)this.key) && StringUtils.equalsIgnoreCase((String)rdn.value, (String)this.value);
    }

    public Object encodeUrl() {
        try {
            URI valueUri = new URI(null, null, this.value, null);
            return String.valueOf(this.key) + "=" + valueUri.toString();
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failed to URL encode value " + this.value), (Throwable)e);
            return String.valueOf(this.key) + "=" + "value";
        }
    }

    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    public String getLdapEncoded() {
        return this.ldapEncoded;
    }
}

