/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.springframework.util.ResourceUtils;

public abstract class Log4jConfigurer {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final long DEFAULT_REFRESH_INTERVAL = 60000L;
    public static final String XML_FILE_EXTENSION = ".xml";

    public static void initLogging(String location) throws FileNotFoundException {
        URL url = ResourceUtils.getURL(location);
        if (location.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configure(url);
        } else {
            PropertyConfigurator.configure(url);
        }
    }

    public static void initLogging(String location, long refreshInterval) throws FileNotFoundException {
        File file = ResourceUtils.getFile(location);
        if (!file.exists()) {
            throw new FileNotFoundException("Log4J config file [" + location + "] not found");
        }
        if (location.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            DOMConfigurator.configureAndWatch(file.getAbsolutePath(), refreshInterval);
        } else {
            PropertyConfigurator.configureAndWatch(file.getAbsolutePath(), refreshInterval);
        }
    }

    public static void shutdownLogging() {
        LogManager.shutdown();
    }

    public static void setWorkingDirSystemProperty(String key) {
        System.setProperty(key, new File("").getAbsolutePath());
    }
}

