/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle;

import com.atlassian.paddle.Arguments;
import com.atlassian.paddle.LoggerOutputReceiver;
import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.configuration.AtlassianUserConfiguration;
import com.atlassian.paddle.configuration.AtlassianUserConfigurationReader;
import com.atlassian.paddle.configuration.ConfigurationException;
import com.atlassian.paddle.connection.ConnectionException;
import com.atlassian.paddle.connection.ConnectionProperties;
import com.atlassian.paddle.connection.DefaultConnectionFactory;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;
import com.atlassian.paddle.search.properties.UserSearchProperties;
import com.atlassian.paddle.task.ConnectionTestTask;
import com.atlassian.paddle.task.DefaultTaskRunner;
import com.atlassian.paddle.task.ListGroupsTask;
import com.atlassian.paddle.task.ListUsersTask;
import com.atlassian.paddle.task.Task;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.springframework.core.io.FileSystemResource;

public class Paddle {
    private static final long BATCH_SIZE = 10L;
    private static final int DEFAULT_COUNT_LIMIT = 10;
    private static final Logger log = Logger.getLogger(Paddle.class);
    private static final double version = 4.0;
    private final InputStream atlassianUserInputStream;
    private final Arguments arguments;
    private OutputReceiver outputReceiver;

    public Paddle(Arguments arguments, InputStream atlassianUserInputStream, OutputReceiver outputReceiver) {
        this.arguments = arguments;
        this.atlassianUserInputStream = atlassianUserInputStream;
        this.outputReceiver = outputReceiver;
    }

    public static void main(String[] args) {
        InputStream is;
        Arguments arguments = new Arguments(args);
        FileSystemResource xmlResource = new FileSystemResource("atlassian-user.xml");
        try {
            is = xmlResource.getInputStream();
        }
        catch (IOException e) {
            log.error("Error loading or finding atlassian-user.xml file: " + e.getMessage(), e);
            return;
        }
        LoggerOutputReceiver receiver = new LoggerOutputReceiver(log);
        Paddle paddle = new Paddle(arguments, is, receiver);
        paddle.testConnectivity();
    }

    public void testConnectivity() {
        Task task;
        AtlassianUserConfigurationReader configurationReader;
        if (this.arguments.contains("debug")) {
            this.outputReceiver.setDebuggingFeedback(true);
        }
        long countLimit = 10L;
        if (this.arguments.contains("limit")) {
            countLimit = Integer.parseInt(this.arguments.getValue("limit"));
        }
        this.outputReceiver.provideInfoFeedback("###########################################################################################################################");
        this.outputReceiver.provideInfoFeedback("");
        this.outputReceiver.provideInfoFeedback("LDAP Support Tool version 4.0");
        this.outputReceiver.provideInfoFeedback("");
        this.outputReceiver.provideInfoFeedback("###########################################################################################################################\n");
        try {
            AtlassianUserConfiguration configuration = new AtlassianUserConfiguration(this.atlassianUserInputStream);
            configurationReader = new AtlassianUserConfigurationReader(configuration, this.outputReceiver);
        }
        catch (ConfigurationException e) {
            this.outputReceiver.provideErrorFeedback("Error reading atlassian-user.xml file: " + e.getMessage(), e);
            return;
        }
        ConnectionProperties connectionProperties = configurationReader.getConnectionProperties();
        UserSearchProperties userSearchProperties = configurationReader.getUserSearchProperties();
        MembershipSearchProperties membershipSearchProperties = configurationReader.getMembershipSearchProperties();
        GroupSearchProperties groupSearchProperties = configurationReader.getGroupSearchProperties();
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory(connectionProperties, this.outputReceiver);
        DefaultTaskRunner taskRunner = new DefaultTaskRunner(connectionFactory);
        try {
            taskRunner.runTask(new ConnectionTestTask(this.outputReceiver), countLimit);
        }
        catch (ConnectionException e) {
            this.outputReceiver.provideErrorFeedback("Failed to connect to LDAP server: " + e.getMessage(), e);
            return;
        }
        this.outputReceiver.provideInfoFeedback("-----------------------------------------------------------------");
        this.outputReceiver.provideInfoFeedback("TEST 1: Search and list " + countLimit + " users");
        this.outputReceiver.provideInfoFeedback("-----------------------------------------------------------------\n");
        try {
            task = new ListUsersTask(userSearchProperties, membershipSearchProperties, groupSearchProperties, this.outputReceiver);
            taskRunner.runTask(task, countLimit);
        }
        catch (ConnectionException e) {
            throw new RuntimeException(e);
        }
        this.outputReceiver.provideInfoFeedback("-----------------------------------------------------------------");
        this.outputReceiver.provideInfoFeedback("TEST 2: Search and list " + countLimit + " groups");
        this.outputReceiver.provideInfoFeedback("-----------------------------------------------------------------\n");
        try {
            task = new ListGroupsTask(groupSearchProperties, membershipSearchProperties, this.outputReceiver);
            taskRunner.runTask(task, countLimit);
        }
        catch (ConnectionException e) {
            throw new RuntimeException(e);
        }
        if (taskRunner.hasErrors()) {
            this.outputReceiver.provideInfoFeedback("The following errors were encountered in running LDAP tests:");
            Iterator iterator = taskRunner.getErrorsIterator();
            while (iterator.hasNext()) {
                String errorMessage = (String)iterator.next();
                this.outputReceiver.provideInfoFeedback("");
                this.outputReceiver.provideInfoFeedback(errorMessage);
            }
            this.outputReceiver.provideInfoFeedback("");
            this.outputReceiver.provideInfoFeedback("Please submit a support ticket at http://support.atlassian.com and attach your atlassian-user.xml and the paddle.log file (located in this directory).");
        }
    }
}

